/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.AbstractNamespaceCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommand;
import org.eclipse.ditto.base.model.signals.commands.CommandJsonDeserializer;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableCommand(typePrefix="namespaces.commands:", name="unblockNamespace")
@Immutable
public final class UnblockNamespace
extends AbstractNamespaceCommand<UnblockNamespace> {
    static final String NAME = "unblockNamespace";
    public static final String TYPE = "namespaces.commands:unblockNamespace";

    private UnblockNamespace(CharSequence namespace, DittoHeaders dittoHeaders) {
        super(namespace, TYPE, dittoHeaders);
    }

    public static UnblockNamespace of(CharSequence namespace, DittoHeaders dittoHeaders) {
        return new UnblockNamespace(namespace, dittoHeaders);
    }

    public static UnblockNamespace fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new CommandJsonDeserializer<UnblockNamespace>(TYPE, jsonObject).deserialize(() -> {
            String namespace = (String)jsonObject.getValueOrThrow(NamespaceCommand.JsonFields.NAMESPACE);
            return new UnblockNamespace((CharSequence)namespace, dittoHeaders);
        });
    }

    @Override
    public UnblockNamespace setDittoHeaders(DittoHeaders dittoHeaders) {
        return new UnblockNamespace((CharSequence)this.getNamespace(), dittoHeaders);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UnblockNamespace;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

