/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableCommandResponse;
import org.eclipse.ditto.base.model.namespaces.signals.commands.AbstractNamespaceCommandResponse;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommandResponse;
import org.eclipse.ditto.base.model.signals.commands.CommandResponseHttpStatusValidator;
import org.eclipse.ditto.base.model.signals.commands.CommandResponseJsonDeserializer;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableCommandResponse(type="namespaces.responses:purgeNamespace")
@Immutable
public final class PurgeNamespaceResponse
extends AbstractNamespaceCommandResponse<PurgeNamespaceResponse> {
    public static final String TYPE = "namespaces.responses:purgeNamespace";
    private static final CommandResponseJsonDeserializer<PurgeNamespaceResponse> JSON_DESERIALIZER = CommandResponseJsonDeserializer.newInstance("namespaces.responses:purgeNamespace", context -> {
        JsonObject jsonObject = context.getJsonObject();
        return new PurgeNamespaceResponse((CharSequence)jsonObject.getValueOrThrow(NamespaceCommandResponse.JsonFields.NAMESPACE), (CharSequence)jsonObject.getValueOrThrow(NamespaceCommandResponse.JsonFields.RESOURCE_TYPE), context.getDeserializedHttpStatus(), context.getDittoHeaders());
    });

    private PurgeNamespaceResponse(CharSequence namespace, CharSequence resourceType, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        super(namespace, resourceType, TYPE, CommandResponseHttpStatusValidator.validateHttpStatus(httpStatus, Arrays.asList(HttpStatus.OK, HttpStatus.INTERNAL_SERVER_ERROR), PurgeNamespaceResponse.class), dittoHeaders);
    }

    public static PurgeNamespaceResponse successful(CharSequence namespace, CharSequence resourceType, DittoHeaders dittoHeaders) {
        return new PurgeNamespaceResponse(namespace, resourceType, HttpStatus.OK, dittoHeaders);
    }

    public static PurgeNamespaceResponse failed(CharSequence namespace, CharSequence resourceType, DittoHeaders dittoHeaders) {
        return new PurgeNamespaceResponse(namespace, resourceType, HttpStatus.INTERNAL_SERVER_ERROR, dittoHeaders);
    }

    public static PurgeNamespaceResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return JSON_DESERIALIZER.deserialize(jsonObject, dittoHeaders);
    }

    public boolean isSuccessful() {
        HttpStatus httpStatus = this.getHttpStatus();
        return httpStatus.isSuccess();
    }

    @Override
    public PurgeNamespaceResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        if (Objects.equals(this.getDittoHeaders(), dittoHeaders)) {
            return this;
        }
        return new PurgeNamespaceResponse(this.getNamespace(), this.getResourceType(), this.getHttpStatus(), dittoHeaders);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PurgeNamespaceResponse that = (PurgeNamespaceResponse)o;
        return that.canEqual(this) && super.equals(that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PurgeNamespaceResponse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", successful=" + this.isSuccessful() + "]";
    }
}

