/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.AbstractNamespaceCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommand;
import org.eclipse.ditto.base.model.signals.commands.CommandJsonDeserializer;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableCommand(typePrefix="namespaces.commands:", name="purgeNamespace")
@Immutable
public final class PurgeNamespace
extends AbstractNamespaceCommand<PurgeNamespace> {
    static final String NAME = "purgeNamespace";
    public static final String TYPE = "namespaces.commands:purgeNamespace";

    private PurgeNamespace(CharSequence namespace, DittoHeaders dittoHeaders) {
        super(namespace, TYPE, dittoHeaders);
    }

    public static PurgeNamespace of(CharSequence namespace, DittoHeaders dittoHeaders) {
        return new PurgeNamespace(namespace, dittoHeaders);
    }

    public static PurgeNamespace fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new CommandJsonDeserializer<PurgeNamespace>(TYPE, jsonObject).deserialize(() -> {
            String namespace = (String)jsonObject.getValueOrThrow(NamespaceCommand.JsonFields.NAMESPACE);
            return new PurgeNamespace((CharSequence)namespace, dittoHeaders);
        });
    }

    @Override
    public PurgeNamespace setDittoHeaders(DittoHeaders dittoHeaders) {
        if (Objects.equals(this.getDittoHeaders(), dittoHeaders)) {
            return this;
        }
        return new PurgeNamespace((CharSequence)this.getNamespace(), dittoHeaders);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PurgeNamespace;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

