/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import java.util.Collections;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableCommandResponse;
import org.eclipse.ditto.base.model.namespaces.signals.commands.AbstractNamespaceCommandResponse;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommandResponse;
import org.eclipse.ditto.base.model.signals.commands.CommandResponseHttpStatusValidator;
import org.eclipse.ditto.base.model.signals.commands.CommandResponseJsonDeserializer;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableCommandResponse(type="namespaces.responses:blockNamespace")
public final class BlockNamespaceResponse
extends AbstractNamespaceCommandResponse<BlockNamespaceResponse> {
    public static final String TYPE = "namespaces.responses:blockNamespace";
    private static final HttpStatus HTTP_STATUS = HttpStatus.OK;
    private static final CommandResponseJsonDeserializer<BlockNamespaceResponse> JSON_DESERIALIZER = CommandResponseJsonDeserializer.newInstance("namespaces.responses:blockNamespace", context -> {
        JsonObject jsonObject = context.getJsonObject();
        return new BlockNamespaceResponse((CharSequence)jsonObject.getValueOrThrow(NamespaceCommandResponse.JsonFields.NAMESPACE), (CharSequence)jsonObject.getValueOrThrow(NamespaceCommandResponse.JsonFields.RESOURCE_TYPE), context.getDeserializedHttpStatus(), context.getDittoHeaders());
    });

    private BlockNamespaceResponse(CharSequence namespace, CharSequence resourceType, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        super(namespace, resourceType, TYPE, CommandResponseHttpStatusValidator.validateHttpStatus(httpStatus, Collections.singleton(HTTP_STATUS), BlockNamespaceResponse.class), dittoHeaders);
    }

    public static BlockNamespaceResponse getInstance(CharSequence namespace, CharSequence resourceType, DittoHeaders dittoHeaders) {
        return new BlockNamespaceResponse(namespace, resourceType, HTTP_STATUS, dittoHeaders);
    }

    public static BlockNamespaceResponse fromJson(JsonObject jsonObject, DittoHeaders headers) {
        return JSON_DESERIALIZER.deserialize(jsonObject, headers);
    }

    @Override
    public BlockNamespaceResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return new BlockNamespaceResponse(this.getNamespace(), this.getResourceType(), this.getHttpStatus(), dittoHeaders);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BlockNamespaceResponse;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

