/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.AbstractNamespaceCommand;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommand;
import org.eclipse.ditto.base.model.signals.commands.CommandJsonDeserializer;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableCommand(typePrefix="namespaces.commands:", name="blockNamespace")
@Immutable
public final class BlockNamespace
extends AbstractNamespaceCommand<BlockNamespace> {
    static final String NAME = "blockNamespace";
    public static final String TYPE = "namespaces.commands:blockNamespace";

    private BlockNamespace(CharSequence namespace, DittoHeaders dittoHeaders) {
        super(namespace, TYPE, dittoHeaders);
    }

    public static BlockNamespace of(CharSequence namespace, DittoHeaders dittoHeaders) {
        return new BlockNamespace(namespace, dittoHeaders);
    }

    public static BlockNamespace fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new CommandJsonDeserializer<BlockNamespace>(TYPE, jsonObject).deserialize(() -> {
            String namespace = (String)jsonObject.getValueOrThrow(NamespaceCommand.JsonFields.NAMESPACE);
            return new BlockNamespace((CharSequence)namespace, dittoHeaders);
        });
    }

    @Override
    public BlockNamespace setDittoHeaders(DittoHeaders dittoHeaders) {
        return new BlockNamespace((CharSequence)this.getNamespace(), dittoHeaders);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BlockNamespace;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

