/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommandResponse;
import org.eclipse.ditto.base.model.signals.commands.AbstractCommandResponse;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;

@Immutable
abstract class AbstractNamespaceCommandResponse<T extends AbstractNamespaceCommandResponse<T>>
extends AbstractCommandResponse<T>
implements NamespaceCommandResponse<T> {
    protected static final String TYPE_PREFIX = "namespaces.responses:";
    private final String namespace;
    private final String resourceType;

    protected AbstractNamespaceCommandResponse(CharSequence namespace, CharSequence resourceType, String responseType, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        super(responseType, httpStatus, dittoHeaders);
        this.namespace = ConditionChecker.argumentNotEmpty(namespace, "namespace").toString();
        this.resourceType = ConditionChecker.argumentNotEmpty(resourceType, "resourceType").toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public JsonPointer getResourcePath() {
        return JsonFactory.emptyPointer();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNamespaceCommandResponse that = (AbstractNamespaceCommandResponse)o;
        return that.canEqual(this) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.resourceType, that.resourceType) && super.equals(that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractNamespaceCommandResponse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.namespace, this.resourceType);
    }

    @Override
    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        Predicate extendedPredicate = schemaVersion.and(predicate);
        jsonObjectBuilder.set(NamespaceCommandResponse.JsonFields.NAMESPACE, (Object)this.getNamespace(), extendedPredicate);
        jsonObjectBuilder.set(NamespaceCommandResponse.JsonFields.RESOURCE_TYPE, (Object)this.getResourceType(), extendedPredicate);
    }

    @Override
    public String toString() {
        return "namespace=" + this.namespace + ", resourceType=" + this.resourceType;
    }
}

