/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces.signals.commands;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.namespaces.signals.commands.NamespaceCommand;
import org.eclipse.ditto.base.model.signals.commands.AbstractCommand;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;

@Immutable
abstract class AbstractNamespaceCommand<T extends AbstractNamespaceCommand<T>>
extends AbstractCommand<T>
implements NamespaceCommand<T> {
    protected static final String TYPE_PREFIX = "namespaces.commands:";
    static final String RESOURCE_TYPE = "namespaces";
    private final String namespace;

    protected AbstractNamespaceCommand(CharSequence namespace, String type, DittoHeaders dittoHeaders) {
        super(type, dittoHeaders);
        this.namespace = ConditionChecker.argumentNotEmpty(namespace, "namespace").toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public JsonPointer getResourcePath() {
        return JsonFactory.emptyPointer();
    }

    @Override
    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractNamespaceCommand that = (AbstractNamespaceCommand)o;
        return that.canEqual(this) && Objects.equals(this.namespace, that.namespace) && super.equals(that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractNamespaceCommand;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.namespace);
    }

    @Override
    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(NamespaceCommand.JsonFields.NAMESPACE, (Object)this.getNamespace(), schemaVersion.and(predicate));
    }

    @Override
    public String toString() {
        return "namespace=" + this.namespace;
    }
}

