/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.namespaces;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="namespace.blocked")
@Immutable
public final class NamespaceBlockedException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "namespace.blocked";
    private static final String DEFAULT_MESSAGE = "Namespace is not available due to an ongoing operation.";
    private static final String MESSAGE_TEMPLATE = "Namespace ''{0}'' is not available due to an ongoing operation.";
    private static final String DEFAULT_DESCRIPTION = "Please try again later.";
    private static final long serialVersionUID = -778531563964056275L;

    private NamespaceBlockedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.CONFLICT, dittoHeaders, message, description, cause, href);
    }

    public static DittoRuntimeExceptionBuilder<NamespaceBlockedException> newBuilder(String namespace) {
        return new Builder().message(MessageFormat.format(MESSAGE_TEMPLATE, namespace)).description(DEFAULT_DESCRIPTION);
    }

    public static NamespaceBlockedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    public DittoRuntimeExceptionBuilder<NamespaceBlockedException> toBuilder() {
        return new Builder().dittoHeaders(this.getDittoHeaders()).message(this.getMessage()).description(this.getDescription().orElse(DEFAULT_DESCRIPTION)).cause(this.getCause()).href((URI)this.getHref().orElse(null));
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    private static final class Builder
    extends DittoRuntimeExceptionBuilder<NamespaceBlockedException> {
        private Builder() {
            this.message(NamespaceBlockedException.DEFAULT_MESSAGE).description(NamespaceBlockedException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected NamespaceBlockedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new NamespaceBlockedException(dittoHeaders, message, description, cause, href);
        }
    }
}

