/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.json;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;

public enum JsonSchemaVersion implements JsonFieldMarker,
Predicate<JsonField>
{
    V_2(2);

    public static final JsonSchemaVersion LATEST;
    private static final JsonKey JSON_KEY;
    private final int schemaVersionNumber;
    private final Predicate<JsonField> predicate;

    private JsonSchemaVersion(int theSchemaVersionNumber) {
        this.schemaVersionNumber = theSchemaVersionNumber;
        this.predicate = jsonField -> jsonField.isMarkedAs((JsonFieldMarker)this, new JsonFieldMarker[0]);
    }

    public static JsonKey getJsonKey() {
        return JSON_KEY;
    }

    public static Optional<JsonSchemaVersion> forInt(int versionInt) {
        return Stream.of(JsonSchemaVersion.values()).filter(sv -> versionInt == sv.toInt()).findFirst();
    }

    public int toInt() {
        return this.schemaVersionNumber;
    }

    @Override
    public boolean test(JsonField jsonField) {
        return this.predicate.test(jsonField);
    }

    public String toString() {
        return String.format("%d", this.toInt());
    }

    static {
        LATEST = V_2;
        JSON_KEY = JsonFactory.newKey((CharSequence)"__schemaVersion");
    }
}

