/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.translator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.AbstractHeaderEntryFilter;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ReadJsonArrayHeadersFilter
extends AbstractHeaderEntryFilter {
    private static final String COMMA_SPLIT_REGEX = ",";
    private final Map<String, HeaderDefinition> headerDefinitions;

    private ReadJsonArrayHeadersFilter(Map<String, HeaderDefinition> headerDefinitions) {
        this.headerDefinitions = Collections.unmodifiableMap(new HashMap<String, HeaderDefinition>(headerDefinitions));
    }

    public static ReadJsonArrayHeadersFilter getInstance(Map<String, HeaderDefinition> headerDefinitions) {
        return new ReadJsonArrayHeadersFilter(ConditionChecker.checkNotNull(headerDefinitions, "headerDefinitions"));
    }

    @Override
    @Nullable
    protected String filterValue(String key, String value) {
        String result = value;
        if (this.isJsonArrayDefinition(key)) {
            JsonArray jsonArray = ReadJsonArrayHeadersFilter.getJsonArray(value);
            result = jsonArray.toString();
        }
        return result;
    }

    private boolean isJsonArrayDefinition(String headerKey) {
        HeaderDefinition headerDefinition = this.headerDefinitions.get(headerKey.toLowerCase());
        boolean result = false;
        if (null != headerDefinition) {
            result = JsonArray.class.equals((Object)headerDefinition.getSerializationType());
        }
        return result;
    }

    private static JsonArray getJsonArray(String headerValue) {
        JsonArray result = headerValue.isEmpty() ? JsonArray.empty() : ReadJsonArrayHeadersFilter.tryToParseJsonArray(headerValue);
        return result;
    }

    private static JsonArray tryToParseJsonArray(String headerValue) {
        try {
            return JsonArray.of((String)headerValue);
        }
        catch (JsonParseException e) {
            return (JsonArray)Arrays.stream(headerValue.split(COMMA_SPLIT_REGEX)).filter(string -> !string.isEmpty()).map(String::trim).map(JsonValue::of).collect(JsonCollectors.valuesToArray());
        }
    }
}

