/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.translator;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.HeaderEntryFilter;
import org.eclipse.ditto.base.model.headers.translator.HeaderEntryFilters;

@Immutable
public final class HeaderTranslator {
    private final Map<String, HeaderDefinition> headerDefinitions;

    private HeaderTranslator(Map<String, HeaderDefinition> headerDefinitionMap) {
        this.headerDefinitions = Collections.unmodifiableMap(headerDefinitionMap);
    }

    public static HeaderTranslator empty() {
        return new HeaderTranslator(Collections.emptyMap());
    }

    public static HeaderTranslator of(HeaderDefinition[] ... headerDefinitions) {
        return new HeaderTranslator(Arrays.stream(headerDefinitions).flatMap(Arrays::stream).collect(Collectors.toMap(HeaderDefinition::getKey, Function.identity(), (headerDefinition, headerDefinition2) -> {
            if (Objects.equals(headerDefinition.getKey(), DittoHeaderDefinition.TIMEOUT.getKey())) {
                return headerDefinition.getSerializationType().equals(String.class) ? headerDefinition : headerDefinition2;
            }
            throw new IllegalStateException("Duplicate key: " + headerDefinition.getKey());
        })));
    }

    public Map<String, String> fromExternalHeaders(Map<String, String> externalHeaders) {
        ConditionChecker.checkNotNull(externalHeaders, "externalHeaders");
        HeaderEntryFilter headerEntryFilter = HeaderEntryFilters.fromExternalHeadersFilter(this.headerDefinitions);
        return HeaderTranslator.filterHeaders(externalHeaders, headerEntryFilter);
    }

    public Map<String, String> toExternalHeaders(DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        HeaderEntryFilter headerEntryFilter = HeaderEntryFilters.toExternalHeadersFilter(this.headerDefinitions);
        return HeaderTranslator.filterHeadersMap(dittoHeaders.asCaseSensitiveMap(), headerEntryFilter);
    }

    public Map<String, String> retainKnownHeaders(Map<String, String> externalHeaders) {
        ConditionChecker.checkNotNull(externalHeaders, "externalHeaders");
        HeaderEntryFilter headerEntryFilter = HeaderEntryFilters.existsAsHeaderDefinition(this.headerDefinitions);
        return HeaderTranslator.filterHeaders(externalHeaders, headerEntryFilter);
    }

    public Map<String, String> toExternalAndRetainKnownHeaders(DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        if (this.headerDefinitions.isEmpty()) {
            return dittoHeaders;
        }
        HeaderEntryFilter headerEntryFilter = HeaderEntryFilters.existsAsHeaderDefinitionAndExternal(this.headerDefinitions);
        return HeaderTranslator.filterHeaders(dittoHeaders, headerEntryFilter);
    }

    private static Map<String, String> filterHeaders(Map<String, String> headersToFilter, HeaderEntryFilter headerEntryFilter) {
        if (headersToFilter instanceof DittoHeaders) {
            return HeaderTranslator.filterDittoHeaders((DittoHeaders)headersToFilter, headerEntryFilter);
        }
        return HeaderTranslator.filterHeadersMap(headersToFilter, headerEntryFilter);
    }

    private static DittoHeaders filterDittoHeaders(DittoHeaders headersToFilter, HeaderEntryFilter headerEntryFilter) {
        DittoHeadersBuilder<?, ?> dittoHeadersBuilder = headersToFilter.toBuilder();
        for (Map.Entry<String, String> entry : headersToFilter.asCaseSensitiveMap().entrySet()) {
            String originalKey = entry.getKey();
            String originalValue = entry.getValue();
            String key = originalKey.toLowerCase();
            String filteredValue = headerEntryFilter.apply(key, originalValue);
            if (null == filteredValue) {
                dittoHeadersBuilder.removeHeader(originalKey);
                continue;
            }
            if (filteredValue.equals(originalValue)) continue;
            dittoHeadersBuilder.putHeader(originalKey, filteredValue);
        }
        return dittoHeadersBuilder.build();
    }

    private static Map<String, String> filterHeadersMap(Map<String, String> headersToFilter, HeaderEntryFilter headerEntryFilter) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(headersToFilter.size());
        headersToFilter.forEach((originalKey, value) -> {
            String lowercaseKey = originalKey.toLowerCase();
            String filteredValue = headerEntryFilter.apply(lowercaseKey, (String)value);
            if (null != filteredValue) {
                result.put((String)originalKey, filteredValue);
            }
        });
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [headerKeys=" + this.headerDefinitions.keySet() + ']';
    }
}

