/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.translator;

import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.CheckExternalFilter;
import org.eclipse.ditto.base.model.headers.translator.DittoAckRequestsFilter;
import org.eclipse.ditto.base.model.headers.translator.HeaderEntryFilter;
import org.eclipse.ditto.base.model.headers.translator.ReadJsonArrayHeadersFilter;

@Immutable
final class HeaderEntryFilters {
    private HeaderEntryFilters() {
        throw new AssertionError();
    }

    static HeaderEntryFilter toExternalHeadersFilter(Map<String, HeaderDefinition> headerDefinitionMap) {
        HeaderEntryFilter headerEntryFilter = HeaderEntryFilters.shouldWriteToExternal(headerDefinitionMap);
        if (headerDefinitionMap.isEmpty()) {
            return headerEntryFilter;
        }
        return headerEntryFilter.andThen(HeaderEntryFilters.discardDittoAckRequests());
    }

    private static HeaderEntryFilter shouldWriteToExternal(Map<String, HeaderDefinition> headerDefinitions) {
        return CheckExternalFilter.shouldWriteToExternal(headerDefinitions);
    }

    private static HeaderEntryFilter readJsonArraysFromHeaders(Map<String, HeaderDefinition> headerDefinitions) {
        return ReadJsonArrayHeadersFilter.getInstance(headerDefinitions);
    }

    private static HeaderEntryFilter discardDittoAckRequests() {
        return DittoAckRequestsFilter.getInstance();
    }

    static HeaderEntryFilter fromExternalHeadersFilter(Map<String, HeaderDefinition> headerDefinitionMap) {
        return CheckExternalFilter.shouldReadFromExternal(headerDefinitionMap).andThen(HeaderEntryFilters.readJsonArraysFromHeaders(headerDefinitionMap));
    }

    static HeaderEntryFilter existsAsHeaderDefinition(Map<String, HeaderDefinition> headerDefinitionMap) {
        return CheckExternalFilter.existsAsHeaderDefinition(headerDefinitionMap);
    }

    static HeaderEntryFilter existsAsHeaderDefinitionAndExternal(Map<String, HeaderDefinition> headerDefinitionMap) {
        return HeaderEntryFilters.existsAsHeaderDefinition(headerDefinitionMap).andThen(HeaderEntryFilters.toExternalHeadersFilter(headerDefinitionMap));
    }
}

