/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.translator;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.DittoAcknowledgementLabel;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.AbstractHeaderEntryFilter;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class DittoAckRequestsFilter
extends AbstractHeaderEntryFilter {
    private static final String TWIN_PERSISTED_ONLY_VALUE = "[\"" + DittoAcknowledgementLabel.TWIN_PERSISTED + "\"]";
    private static final String LIVE_RESPONSE_ONLY_VALUE = "[\"" + DittoAcknowledgementLabel.LIVE_RESPONSE + "\"]";
    private static final JsonValue EMPTY_JSON_STRING = JsonValue.of((String)"");
    private static final DittoAckRequestsFilter INSTANCE = new DittoAckRequestsFilter();

    private DittoAckRequestsFilter() {
    }

    public static DittoAckRequestsFilter getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String filterValue(String key, String value) {
        Object result = DittoAckRequestsFilter.isRequestedAcks(key) ? (value.isEmpty() || DittoAckRequestsFilter.isTwinPersistedOnly(value) || DittoAckRequestsFilter.isLiveResponseOnly(value) ? null : DittoAckRequestsFilter.tryToParseAsJsonArrayAndFilter(value)) : value;
        return result;
    }

    private static boolean isTwinPersistedOnly(String value) {
        return TWIN_PERSISTED_ONLY_VALUE.equals(value);
    }

    private static boolean isLiveResponseOnly(String value) {
        return LIVE_RESPONSE_ONLY_VALUE.equals(value);
    }

    private static boolean isRequestedAcks(String key) {
        return Objects.equals(DittoHeaderDefinition.REQUESTED_ACKS.getKey(), key);
    }

    @Nullable
    private static String tryToParseAsJsonArrayAndFilter(String value) {
        try {
            return DittoAckRequestsFilter.parseAsJsonArrayAndFilter(value);
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nullable
    private static String parseAsJsonArrayAndFilter(String value) {
        JsonArray originalAckRequestsJsonArray = JsonArray.of((String)value);
        JsonArray filteredAckRequestsJsonArray = (JsonArray)originalAckRequestsJsonArray.stream().filter(JsonValue::isString).filter(jsonValue -> !jsonValue.equals(EMPTY_JSON_STRING)).filter(jsonValue -> !DittoAckRequestsFilter.isDittoInternal(jsonValue)).collect(JsonCollectors.valuesToArray());
        boolean allElementsFiltered = filteredAckRequestsJsonArray.isEmpty() && !originalAckRequestsJsonArray.isEmpty();
        return allElementsFiltered ? null : filteredAckRequestsJsonArray.toString();
    }

    private static boolean isDittoInternal(JsonValue ackRequestLabelJsonValue) {
        return DittoAcknowledgementLabel.contains(AcknowledgementLabel.of(ackRequestLabelJsonValue.asString()));
    }
}

