/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.translator;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.translator.AbstractHeaderEntryFilter;

@Immutable
final class CheckExternalFilter
extends AbstractHeaderEntryFilter {
    private final Map<String, HeaderDefinition> headerDefinitions;
    private final Predicate<HeaderDefinition> headerDefinitionPredicate;

    private CheckExternalFilter(Map<String, HeaderDefinition> headerDefinitions, Predicate<HeaderDefinition> headerDefinitionPredicate) {
        this.headerDefinitions = Collections.unmodifiableMap(ConditionChecker.checkNotNull(headerDefinitions, "headerDefinitions"));
        this.headerDefinitionPredicate = headerDefinitionPredicate;
    }

    public static CheckExternalFilter shouldReadFromExternal(Map<String, HeaderDefinition> headerDefinitions) {
        return new CheckExternalFilter(headerDefinitions, CheckExternalFilter.isNull().or(HeaderDefinition::shouldReadFromExternalHeaders));
    }

    public static CheckExternalFilter shouldWriteToExternal(Map<String, HeaderDefinition> headerDefinitions) {
        return new CheckExternalFilter(headerDefinitions, CheckExternalFilter.isNull().or(HeaderDefinition::shouldWriteToExternalHeaders));
    }

    public static CheckExternalFilter existsAsHeaderDefinition(Map<String, HeaderDefinition> headerDefinitions) {
        return new CheckExternalFilter(headerDefinitions, Objects::nonNull);
    }

    private static Predicate<HeaderDefinition> isNull() {
        return Objects::isNull;
    }

    @Override
    @Nullable
    protected String filterValue(String key, String value) {
        HeaderDefinition headerDefinition = this.headerDefinitions.get(key.toLowerCase());
        if (this.headerDefinitionPredicate.test(headerDefinition)) {
            return value;
        }
        return null;
    }
}

