/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.metadata;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.metadata.MetadataHeader;
import org.eclipse.ditto.base.model.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonValue;

@NotThreadSafe
final class DefaultMetadataHeaders
extends AbstractSet<MetadataHeader>
implements MetadataHeaders {
    private final SortedSet<MetadataHeader> treeSet;

    private DefaultMetadataHeaders(SortedSet<MetadataHeader> treeSet) {
        this.treeSet = treeSet;
    }

    static DefaultMetadataHeaders newInstance() {
        return new DefaultMetadataHeaders(new TreeSet<MetadataHeader>());
    }

    static DefaultMetadataHeaders parseMetadataHeaders(CharSequence metadataHeadersCharSequence) {
        ConditionChecker.checkNotNull(metadataHeadersCharSequence, "metadataHeadersCharSequence");
        DefaultMetadataHeaders result = 0 < metadataHeadersCharSequence.length() ? DefaultMetadataHeaders.parseJsonArray(JsonArray.of((String)metadataHeadersCharSequence.toString())) : DefaultMetadataHeaders.newInstance();
        return result;
    }

    private static DefaultMetadataHeaders parseJsonArray(JsonArray jsonArray) {
        TreeSet delegationTarget = jsonArray.stream().filter(JsonValue::isObject).map(JsonValue::asObject).map(MetadataHeader::fromJson).collect(Collectors.toCollection(TreeSet::new));
        return new DefaultMetadataHeaders(delegationTarget);
    }

    @Override
    public JsonArray toJson() {
        return (JsonArray)this.treeSet.stream().map(Jsonifiable::toJson).collect(JsonCollectors.valuesToArray());
    }

    @Override
    public boolean add(MetadataHeader metadataHeader) {
        return this.treeSet.add(metadataHeader);
    }

    @Override
    public boolean addAll(Collection<? extends MetadataHeader> c) {
        return this.treeSet.addAll(c);
    }

    @Override
    public Iterator<MetadataHeader> iterator() {
        return this.treeSet.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.treeSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.treeSet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.treeSet.retainAll(c);
    }

    @Override
    public void clear() {
        this.treeSet.clear();
    }

    @Override
    public int size() {
        return this.treeSet.size();
    }

    @Override
    public Comparator<? super MetadataHeader> comparator() {
        return this.treeSet.comparator();
    }

    @Override
    public SortedSet<MetadataHeader> subSet(MetadataHeader metadataHeader, MetadataHeader e1) {
        return this.treeSet.subSet(metadataHeader, e1);
    }

    @Override
    public SortedSet<MetadataHeader> headSet(MetadataHeader metadataHeader) {
        return this.treeSet.headSet(metadataHeader);
    }

    @Override
    public SortedSet<MetadataHeader> tailSet(MetadataHeader metadataHeader) {
        return this.treeSet.tailSet(metadataHeader);
    }

    @Override
    public MetadataHeader first() {
        return this.treeSet.first();
    }

    @Override
    public MetadataHeader last() {
        return this.treeSet.last();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultMetadataHeaders that = (DefaultMetadataHeaders)o;
        return Objects.equals(this.treeSet, that.treeSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.treeSet);
    }
}

