/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.entitytag;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;

@Immutable
public final class EntityTagMatcher {
    static final String ASTERISK = "*";
    private static final EntityTagMatcher ASTERISK_INSTANCE = new EntityTagMatcher(null, true);
    @Nullable
    private final EntityTag entityTag;
    private final boolean isAsterisk;

    private EntityTagMatcher(@Nullable EntityTag entityTag, boolean isAsterisk) {
        this.entityTag = entityTag;
        this.isAsterisk = isAsterisk;
    }

    public static EntityTagMatcher fromString(String entityTagMatcher) {
        if (EntityTagMatcher.isAsterisk(entityTagMatcher)) {
            return ASTERISK_INSTANCE;
        }
        EntityTag parsedEntityTag = EntityTag.fromString(entityTagMatcher);
        return new EntityTagMatcher(ConditionChecker.checkNotNull(parsedEntityTag, "entityTag"), false);
    }

    private static boolean isAsterisk(@Nullable CharSequence entityTagMatcher) {
        boolean result = false;
        if (null != entityTagMatcher) {
            result = ASTERISK.equals(entityTagMatcher.toString());
        }
        return result;
    }

    public static EntityTagMatcher asterisk() {
        return ASTERISK_INSTANCE;
    }

    public static boolean isValid(@Nullable CharSequence entityTagMatcher) {
        boolean result = false;
        if (null != entityTagMatcher) {
            result = EntityTagMatcher.isAsterisk(entityTagMatcher) || EntityTag.isValid(entityTagMatcher);
        }
        return result;
    }

    public boolean strongMatch(EntityTag entityTagToMatch) {
        if (this.isAsterisk) {
            return true;
        }
        return this.entityTag.strongCompareTo(entityTagToMatch);
    }

    public boolean weakMatch(EntityTag entityTagToMatch) {
        if (this.isAsterisk) {
            return true;
        }
        return this.entityTag.weakCompareTo(entityTagToMatch);
    }

    public boolean isAsterisk() {
        return this.isAsterisk;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTagMatcher that = (EntityTagMatcher)o;
        return this.isAsterisk == that.isAsterisk && Objects.equals(this.entityTag, that.entityTag);
    }

    public int hashCode() {
        return Objects.hash(this.isAsterisk, this.entityTag);
    }

    public String toString() {
        return this.isAsterisk ? ASTERISK : this.entityTag.toString();
    }
}

