/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers.entitytag;

import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.Entity;
import org.eclipse.ditto.base.model.entity.Revision;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;

final class EntityTagBuilder {
    private static final String TOP_LEVEL_ENTITY_PREFIX = "rev:";
    private static final String SUB_RESOURCE_PREFIX = "hash:";

    private EntityTagBuilder() {
    }

    static Optional<EntityTag> buildFromEntity(@Nullable Object entity) {
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof Entity) {
            return EntityTagBuilder.buildForTopLevelEntity((Entity)entity);
        }
        return EntityTagBuilder.buildForSubEntity(entity);
    }

    private static Optional<EntityTag> buildForTopLevelEntity(Entity<? extends Revision> topLevelEntity) {
        if (topLevelEntity.isDeleted()) {
            return Optional.empty();
        }
        return topLevelEntity.getRevision().map(Revision::toString).map(value -> TOP_LEVEL_ENTITY_PREFIX + value).map(EntityTagBuilder::enquote).map(EntityTag::strong);
    }

    private static Optional<EntityTag> buildForSubEntity(Object object) {
        return Optional.of(object.hashCode()).map(Integer::toHexString).map(value -> SUB_RESOURCE_PREFIX + value).map(EntityTagBuilder::enquote).map(EntityTag::strong);
    }

    private static String enquote(String stringToPutInQuotes) {
        return "\"" + stringToPutInQuotes + "\"";
    }
}

