/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabelInvalidException;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class RequestedAcksValueValidator
extends AbstractHeaderValueValidator {
    private static final RequestedAcksValueValidator INSTANCE = new RequestedAcksValueValidator();

    private RequestedAcksValueValidator() {
        super(JsonArray.class::equals);
    }

    static RequestedAcksValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        JsonArray jsonArray;
        try {
            jsonArray = JsonArray.of((String)value.toString());
        }
        catch (JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "JSON array").build();
        }
        for (JsonValue jsonValue : jsonArray) {
            if (jsonValue.isString()) {
                try {
                    AcknowledgementLabel.of(jsonValue.asString());
                    continue;
                }
                catch (AcknowledgementLabelInvalidException e) {
                    throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "JSON array of acknowledgement labels").cause(e).build();
                }
            }
            String msgTemplate = "JSON array for <{0}> contained invalid acknowledgement labels.";
            String invalidHeaderKey = definition.getKey();
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newBuilder().withInvalidHeaderKey(invalidHeaderKey).message(MessageFormat.format("JSON array for <{0}> contained invalid acknowledgement labels.", invalidHeaderKey)).build();
        }
    }
}

