/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;

@Immutable
final class NonEmptyValueValidator
extends AbstractHeaderValueValidator {
    private static final String MESSAGE_TEMPLATE = "The value of the header ''{0}'' must not be empty.";
    private static final NonEmptyValueValidator INSTANCE = new NonEmptyValueValidator();

    private NonEmptyValueValidator() {
        super(CharSequence.class::isAssignableFrom);
    }

    static NonEmptyValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        if (value.length() < 1) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newBuilder().message(MessageFormat.format(MESSAGE_TEMPLATE, definition.getKey())).build();
        }
    }
}

