/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonRuntimeException;

@Immutable
final class MetadataHeadersValueValidator
extends AbstractHeaderValueValidator {
    private MetadataHeadersValueValidator() {
        super(JsonArray.class::equals);
    }

    static MetadataHeadersValueValidator getInstance() {
        return new MetadataHeadersValueValidator();
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            MetadataHeaders.parseMetadataHeaders(value);
        }
        catch (JsonMissingFieldException | JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "MetadataHeaders").description(MetadataHeadersValueValidator.getDescription((JsonRuntimeException)e)).cause(e).build();
        }
    }

    private static String getDescription(JsonRuntimeException jsonRuntimeException) {
        String message = jsonRuntimeException.getMessage();
        return jsonRuntimeException.getDescription().map(description -> message + " " + description).orElse(message);
    }
}

