/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

@Immutable
final class JsonObjectValueValidator
extends AbstractHeaderValueValidator {
    private static final JsonObjectValueValidator INSTANCE = new JsonObjectValueValidator();

    private JsonObjectValueValidator() {
        super(JsonObject.class::equals);
    }

    static JsonObjectValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        JsonObjectValueValidator.tryToParseJsonObject(definition, value.toString());
    }

    private static JsonObject tryToParseJsonObject(HeaderDefinition definition, String value) {
        try {
            return JsonObject.of((String)value);
        }
        catch (JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, (CharSequence)value, "JSON object").build();
        }
    }
}

