/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelectorInvalidException;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonRuntimeException;

@Immutable
final class JsonFieldSelectorValidator
extends AbstractHeaderValueValidator {
    private static final JsonParseOptions JSON_FIELD_SELECTOR_PARSE_OPTIONS = JsonFactory.newParseOptionsBuilder().withoutUrlDecoding().build();

    private JsonFieldSelectorValidator() {
        super(String.class::equals);
    }

    static JsonFieldSelectorValidator getInstance() {
        return new JsonFieldSelectorValidator();
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            JsonFactory.newFieldSelector((String)value.toString(), (JsonParseOptions)JSON_FIELD_SELECTOR_PARSE_OPTIONS);
        }
        catch (JsonFieldSelectorInvalidException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "field selector").description(JsonFieldSelectorValidator.getDescription((JsonRuntimeException)((Object)e))).cause(e).build();
        }
    }

    private static String getDescription(JsonRuntimeException jsonRuntimeException) {
        String message = jsonRuntimeException.getMessage();
        return jsonRuntimeException.getDescription().map(description -> message + " " + description).orElse(message);
    }
}

