/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class JsonArrayValueValidator
extends AbstractHeaderValueValidator {
    private static final JsonArrayValueValidator INSTANCE = new JsonArrayValueValidator();

    private JsonArrayValueValidator() {
        super(JsonArray.class::equals);
    }

    static JsonArrayValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        if (JsonArrayValueValidator.containsNonStringArrayValues((Iterable<JsonValue>)JsonArrayValueValidator.tryToParseJsonArray(definition, value.toString()))) {
            String msgTemplate = "JSON array for <{0}> contained non-string values!";
            String invalidHeaderKey = definition.getKey();
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newBuilder().withInvalidHeaderKey(invalidHeaderKey).message(MessageFormat.format("JSON array for <{0}> contained non-string values!", invalidHeaderKey)).build();
        }
    }

    private static JsonArray tryToParseJsonArray(HeaderDefinition definition, String value) {
        try {
            return JsonArray.of((String)value);
        }
        catch (JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, (CharSequence)value, "JSON array").build();
        }
    }

    private static boolean containsNonStringArrayValues(Iterable<JsonValue> jsonArray) {
        for (JsonValue jsonValue : jsonArray) {
            if (jsonValue.isString()) continue;
            return true;
        }
        return false;
    }
}

