/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;

@Immutable
final class IntValueValidator
extends AbstractHeaderValueValidator {
    private static final IntValueValidator INSTANCE = new IntValueValidator();

    private IntValueValidator() {
        super(valueType -> Integer.TYPE.equals(valueType) || Integer.class.equals(valueType));
    }

    static IntValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "int").build();
        }
    }
}

