/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.BooleanValueValidator;
import org.eclipse.ditto.base.model.headers.DittoChannelValueValidator;
import org.eclipse.ditto.base.model.headers.DittoDurationValueValidator;
import org.eclipse.ditto.base.model.headers.EntityTagMatcherValueValidator;
import org.eclipse.ditto.base.model.headers.EntityTagMatchersValueValidator;
import org.eclipse.ditto.base.model.headers.EntityTagValueValidator;
import org.eclipse.ditto.base.model.headers.EnumValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.IntValueValidator;
import org.eclipse.ditto.base.model.headers.JsonArrayValueValidator;
import org.eclipse.ditto.base.model.headers.JsonFieldSelectorValidator;
import org.eclipse.ditto.base.model.headers.JsonObjectValueValidator;
import org.eclipse.ditto.base.model.headers.LongValueValidator;
import org.eclipse.ditto.base.model.headers.MetadataHeadersValueValidator;
import org.eclipse.ditto.base.model.headers.NonEmptyValueValidator;
import org.eclipse.ditto.base.model.headers.RequestedAcksValueValidator;
import org.eclipse.ditto.base.model.headers.TimeoutValueValidator;
import org.eclipse.ditto.base.model.headers.ValueValidator;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTagMatchers;

@Immutable
public final class HeaderValueValidators {
    private HeaderValueValidators() {
        throw new AssertionError();
    }

    public static ValueValidator getNoOpValidator() {
        return new AbstractHeaderValueValidator(valueType -> true){

            @Override
            protected void validateValue(HeaderDefinition definition, CharSequence value) {
            }
        };
    }

    public static ValueValidator getNonEmptyValidator() {
        return NonEmptyValueValidator.getInstance();
    }

    public static ValueValidator getIntValidator() {
        return IntValueValidator.getInstance();
    }

    public static ValueValidator getLongValidator() {
        return LongValueValidator.getInstance();
    }

    public static ValueValidator getBooleanValidator() {
        return BooleanValueValidator.getInstance();
    }

    public static ValueValidator getEnumValidator(Enum<?>[] enumValues) {
        return EnumValueValidator.getInstance(enumValues);
    }

    public static ValueValidator getJsonArrayValidator() {
        return JsonArrayValueValidator.getInstance();
    }

    public static ValueValidator getJsonObjectValidator() {
        return JsonObjectValueValidator.getInstance();
    }

    static ValueValidator getEntityTagValidator() {
        return EntityTagValueValidator.getInstance();
    }

    static ValueValidator getEntityTagMatcherValidator() {
        return EntityTagMatcherValueValidator.getInstance();
    }

    static ValueValidator getEntityTagMatchersValidator() {
        return EntityTagMatchersValueValidator.getInstance(EntityTagMatcherValueValidator.getInstance(EntityTagMatchers.class::equals));
    }

    static ValueValidator getRequestedAcksValueValidator() {
        return RequestedAcksValueValidator.getInstance();
    }

    static ValueValidator getDittoDurationValidator() {
        return DittoDurationValueValidator.getInstance();
    }

    static ValueValidator getTimeoutValueValidator() {
        return TimeoutValueValidator.getInstance();
    }

    static ValueValidator getMetadataHeadersValidator() {
        return MetadataHeadersValueValidator.getInstance();
    }

    static ValueValidator getJsonFieldSelectorValidator() {
        return JsonFieldSelectorValidator.getInstance();
    }

    static ValueValidator getDittoChannelValidator() {
        return DittoChannelValueValidator.getInstance();
    }
}

