/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;

@Immutable
final class EnumValueValidator
extends AbstractHeaderValueValidator {
    private final Set<String> enumValueSet;
    private final String errorDescription;
    private final Class<?> enumDeclaringType;

    private EnumValueValidator(List<Enum<?>> enumValues) {
        super(String.class::equals);
        this.enumDeclaringType = enumValues.get(0).getDeclaringClass();
        this.enumValueSet = Collections.unmodifiableSet(new LinkedHashSet<String>(EnumValueValidator.groupByNormalizedName(enumValues)));
        this.errorDescription = EnumValueValidator.formatErrorDescription(this.enumValueSet);
    }

    static EnumValueValidator getInstance(Enum<?>[] enumValues) {
        ConditionChecker.checkNotNull(enumValues, "enumValues");
        List<Enum<?>> enums = Arrays.asList(enumValues);
        ConditionChecker.checkNotEmpty(enums, "enumValues");
        return new EnumValueValidator(enums);
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        String normalizedValue = EnumValueValidator.normalize(value);
        if (!this.enumValueSet.contains(normalizedValue)) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "enum value of type '" + this.enumDeclaringType.getSimpleName() + "'").description(this.errorDescription).build();
        }
    }

    private static String normalize(CharSequence charSequence) {
        return charSequence.toString().trim().toLowerCase(Locale.ENGLISH);
    }

    private static List<String> groupByNormalizedName(Collection<Enum<?>> enumValues) {
        return enumValues.stream().map(Enum::toString).map(EnumValueValidator::normalize).collect(Collectors.toList());
    }

    private static String formatErrorDescription(Collection<String> normalizedNames) {
        String valuesString = String.join((CharSequence)"|", normalizedNames);
        return MessageFormat.format("The value must be one of: <{0}>.", valuesString);
    }
}

