/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;

@Immutable
final class EntityTagValueValidator
extends AbstractHeaderValueValidator {
    static final String RFC_7232_SECTION_2_3 = "https://tools.ietf.org/html/rfc7232#section-2.3";
    private static final EntityTagValueValidator INSTANCE = new EntityTagValueValidator();

    private EntityTagValueValidator() {
        super(EntityTag.class::equals);
    }

    static EntityTagValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        if (!EntityTag.isValid(value)) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "entity-tag").href(RFC_7232_SECTION_2_3).build();
        }
    }
}

