/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.eclipse.ditto.base.model.acks.AcknowledgementRequest;
import org.eclipse.ditto.base.model.auth.AuthorizationContext;
import org.eclipse.ditto.base.model.auth.AuthorizationSubject;
import org.eclipse.ditto.base.model.common.ResponseType;
import org.eclipse.ditto.base.model.headers.DefaultDittoHeadersBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.headers.LiveChannelTimeoutStrategy;
import org.eclipse.ditto.base.model.headers.WithManifest;
import org.eclipse.ditto.base.model.headers.contenttype.ContentType;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.base.model.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;

public interface DittoHeaders
extends Jsonifiable<JsonObject>,
Map<String, String>,
WithManifest {
    public static DittoHeaders empty() {
        return DefaultDittoHeadersBuilder.getEmptyHeaders();
    }

    public static DittoHeaders of(Map<String, String> headers) {
        if (headers instanceof DittoHeaders) {
            return (DittoHeaders)headers;
        }
        return DittoHeaders.newBuilder(headers).build();
    }

    public static DittoHeadersBuilder newBuilder() {
        return DefaultDittoHeadersBuilder.newInstance();
    }

    public static DittoHeadersBuilder newBuilder(Map<String, String> headers) {
        return DefaultDittoHeadersBuilder.of(headers);
    }

    public static DittoHeadersBuilder newBuilder(JsonObject jsonObject) {
        return DefaultDittoHeadersBuilder.of(jsonObject);
    }

    default public DittoHeadersBuilder<?, ?> toBuilder() {
        return DefaultDittoHeadersBuilder.of(this);
    }

    public Optional<String> getCorrelationId();

    public Optional<String> getContentType();

    public Optional<String> getAccept();

    public Optional<ContentType> getDittoContentType();

    public Optional<JsonSchemaVersion> getSchemaVersion();

    public AuthorizationContext getAuthorizationContext();

    public Set<AuthorizationSubject> getReadGrantedSubjects();

    public Set<AuthorizationSubject> getReadRevokedSubjects();

    public Optional<String> getChannel();

    public boolean isResponseRequired();

    public boolean isDryRun();

    public boolean isSudo();

    public boolean shouldRetrieveDeleted();

    public Optional<String> getCondition();

    public Optional<String> getLiveChannelCondition();

    public boolean didLiveChannelConditionMatch();

    public Optional<String> getOrigin();

    public Optional<EntityTag> getETag();

    public Optional<EntityTagMatchers> getIfMatch();

    public Optional<EntityTagMatchers> getIfNoneMatch();

    public Optional<String> getInboundPayloadMapper();

    public Optional<Integer> getReplyTarget();

    public Collection<ResponseType> getExpectedResponseTypes();

    public boolean isEntriesSizeGreaterThan(long var1);

    public DittoHeaders truncate(long var1);

    public Set<AcknowledgementRequest> getAcknowledgementRequests();

    public Optional<Duration> getTimeout();

    public Optional<LiveChannelTimeoutStrategy> getLiveChannelTimeoutStrategy();

    public MetadataHeaders getMetadataHeadersToPut();

    public Set<JsonPointer> getMetadataFieldsToGet();

    public Set<JsonPointer> getMetadataFieldsToDelete();

    public boolean isAllowPolicyLockout();

    public Set<String> getJournalTags();

    public Optional<String> getTraceParent();

    public Optional<String> getTraceState();

    public Map<String, String> asCaseSensitiveMap();

    @Override
    @Nonnull
    default public String getManifest() {
        return DittoHeaders.class.getSimpleName();
    }
}

