/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.DittoDuration;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.HeaderValueValidators;
import org.eclipse.ditto.base.model.headers.LiveChannelTimeoutStrategy;
import org.eclipse.ditto.base.model.headers.ValueValidator;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonObject;

public enum DittoHeaderDefinition implements HeaderDefinition
{
    AUTHORIZATION_CONTEXT("ditto-auth-context", JsonObject.class, false, false, HeaderValueValidators.getJsonObjectValidator()),
    CORRELATION_ID("correlation-id", String.class, true, true, HeaderValueValidators.getNonEmptyValidator()),
    SCHEMA_VERSION("version", Integer.TYPE, true, true, HeaderValueValidators.getIntValidator()),
    RESPONSE_REQUIRED("response-required", Boolean.TYPE, true, true, HeaderValueValidators.getBooleanValidator()),
    DRY_RUN("ditto-dry-run", Boolean.TYPE, false, false, HeaderValueValidators.getBooleanValidator()),
    READ_SUBJECTS("ditto-read-subjects", JsonArray.class, false, false, HeaderValueValidators.getJsonArrayValidator()),
    READ_REVOKED_SUBJECTS("ditto-read-revoked-subjects", JsonArray.class, false, false, HeaderValueValidators.getJsonArrayValidator()),
    CONTENT_TYPE("content-type", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    ACCEPT("accept", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    REPLY_TO("reply-to", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    CHANNEL("channel", String.class, true, true, HeaderValueValidators.getDittoChannelValidator()),
    LIVE_CHANNEL_TIMEOUT_STRATEGY("live-channel-timeout-strategy", LiveChannelTimeoutStrategy.class, String.class, true, false, HeaderValueValidators.getEnumValidator(LiveChannelTimeoutStrategy.values())),
    ORIGIN("ditto-origin", String.class, false, false, HeaderValueValidators.getNoOpValidator()),
    ETAG("etag", EntityTag.class, String.class, false, true, HeaderValueValidators.getEntityTagValidator()),
    IF_MATCH("if-match", EntityTagMatchers.class, String.class, true, false, HeaderValueValidators.getEntityTagMatchersValidator()),
    IF_NONE_MATCH("if-none-match", EntityTagMatchers.class, String.class, true, false, HeaderValueValidators.getEntityTagMatchersValidator()),
    REPLY_TARGET("ditto-reply-target", Integer.class, false, false, HeaderValueValidators.getIntValidator()),
    EXPECTED_RESPONSE_TYPES("ditto-expected-response-types", JsonArray.class, false, false, HeaderValueValidators.getJsonArrayValidator()),
    INBOUND_PAYLOAD_MAPPER("ditto-inbound-payload-mapper", String.class, false, false, HeaderValueValidators.getNoOpValidator()),
    ORIGINATOR("ditto-originator", String.class, false, true, HeaderValueValidators.getNoOpValidator()),
    REQUESTED_ACKS("requested-acks", JsonArray.class, true, true, HeaderValueValidators.getRequestedAcksValueValidator()),
    DECLARED_ACKS("declared-acks", JsonArray.class, true, false, HeaderValueValidators.getJsonArrayValidator()),
    TIMEOUT("timeout", DittoDuration.class, String.class, true, true, HeaderValueValidators.getTimeoutValueValidator()),
    ENTITY_ID("ditto-entity-id", String.class, false, false, HeaderValueValidators.getNoOpValidator()),
    WWW_AUTHENTICATE("www-authenticate", String.class, false, true, HeaderValueValidators.getNoOpValidator()),
    LOCATION("location", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    CONNECTION_ID("ditto-connection-id", String.class, false, true, HeaderValueValidators.getNoOpValidator()),
    PUT_METADATA("put-metadata", JsonArray.class, true, false, HeaderValueValidators.getMetadataHeadersValidator()),
    GET_METADATA("get-metadata", String.class, true, false, HeaderValueValidators.getJsonFieldSelectorValidator()),
    DELETE_METADATA("delete-metadata", String.class, true, false, HeaderValueValidators.getJsonFieldSelectorValidator()),
    DITTO_METADATA("ditto-metadata", JsonObject.class, false, true, HeaderValueValidators.getNoOpValidator()),
    ALLOW_POLICY_LOCKOUT("allow-policy-lockout", Boolean.TYPE, true, false, HeaderValueValidators.getBooleanValidator()),
    WEAK_ACK("ditto-weak-ack", Boolean.TYPE, false, true, HeaderValueValidators.getBooleanValidator()),
    EVENT_JOURNAL_TAGS("ditto-event-journal-tags", JsonArray.class, false, false, HeaderValueValidators.getJsonArrayValidator()),
    W3C_TRACEPARENT("traceparent", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    W3C_TRACESTATE("tracestate", String.class, true, true, HeaderValueValidators.getNoOpValidator()),
    DITTO_SUDO("ditto-sudo", Boolean.TYPE, false, false, HeaderValueValidators.getBooleanValidator()),
    DITTO_RETRIEVE_DELETED("ditto-retrieve-deleted", Boolean.TYPE, false, false, HeaderValueValidators.getBooleanValidator()),
    DITTO_ACKREGATOR_ADDRESS("ditto-ackgregator-address", String.class, false, false, HeaderValueValidators.getNonEmptyValidator()),
    CONDITION("condition", String.class, true, false, HeaderValueValidators.getNoOpValidator()),
    LIVE_CHANNEL_CONDITION("live-channel-condition", String.class, true, false, HeaderValueValidators.getNoOpValidator()),
    LIVE_CHANNEL_CONDITION_MATCHED("live-channel-condition-matched", Boolean.class, false, true, HeaderValueValidators.getBooleanValidator());

    private static final Map<CharSequence, DittoHeaderDefinition> VALUES_BY_KEY;
    private final String key;
    private final Class<?> type;
    private final Class<?> serializationType;
    private final boolean readFromExternalHeaders;
    private final boolean writeToExternalHeaders;
    private final ValueValidator valueValidator;

    private DittoHeaderDefinition(String theKey, Class<?> theType, boolean readFromExternalHeaders, boolean writeToExternalHeaders, ValueValidator valueValidator) {
        this(theKey, theType, theType, readFromExternalHeaders, writeToExternalHeaders, valueValidator);
    }

    private DittoHeaderDefinition(String theKey, Class<?> theType, Class<?> serializationType, boolean readFromExternalHeaders, boolean writeToExternalHeaders, ValueValidator valueValidator) {
        this.key = theKey.toLowerCase();
        this.type = theType;
        this.serializationType = serializationType;
        this.readFromExternalHeaders = readFromExternalHeaders;
        this.writeToExternalHeaders = writeToExternalHeaders;
        this.valueValidator = valueValidator;
    }

    public static Optional<HeaderDefinition> forKey(@Nullable CharSequence key) {
        return Optional.ofNullable((HeaderDefinition)VALUES_BY_KEY.get(key));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Class<?> getJavaType() {
        return this.type;
    }

    @Override
    public Class<?> getSerializationType() {
        return this.serializationType;
    }

    @Override
    public boolean shouldReadFromExternalHeaders() {
        return this.readFromExternalHeaders;
    }

    @Override
    public boolean shouldWriteToExternalHeaders() {
        return this.writeToExternalHeaders;
    }

    @Override
    public void validateValue(@Nullable CharSequence value) {
        this.valueValidator.accept(this, value);
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    static {
        VALUES_BY_KEY = Arrays.stream(DittoHeaderDefinition.values()).collect(Collectors.toMap(DittoHeaderDefinition::getKey, Function.identity()));
    }
}

