/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;

@Immutable
final class DittoChannelValueValidator
extends AbstractHeaderValueValidator {
    static final String CHANNEL_TWIN = "twin";
    static final String CHANNEL_LIVE = "live";

    private DittoChannelValueValidator() {
        super(String.class::equals);
    }

    static DittoChannelValueValidator getInstance() {
        return new DittoChannelValueValidator();
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        String normalizedValue = DittoChannelValueValidator.normalize(value);
        if (!CHANNEL_TWIN.equals(normalizedValue) && !CHANNEL_LIVE.equals(normalizedValue)) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, DittoHeaderDefinition.CHANNEL.getKey()).description(MessageFormat.format("The value must either be <{0}> or <{1}>.", CHANNEL_TWIN, CHANNEL_LIVE)).build();
        }
    }

    private static String normalize(CharSequence charSequence) {
        return charSequence.toString().trim().toLowerCase(Locale.ENGLISH);
    }
}

