/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.base.model.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;

@Immutable
final class BooleanValueValidator
extends AbstractHeaderValueValidator {
    private static final BooleanValueValidator INSTANCE = new BooleanValueValidator();

    private BooleanValueValidator() {
        super(valueType -> Boolean.TYPE.equals(valueType) || Boolean.class.equals(valueType));
    }

    static BooleanValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        String trueString = Boolean.TRUE.toString();
        String falseString = Boolean.FALSE.toString();
        String valueString = value.toString();
        if (!trueString.equals(valueString) && !falseString.equals(valueString)) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "boolean").build();
        }
    }
}

