/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.headers;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementRequest;
import org.eclipse.ditto.base.model.auth.AuthorizationContext;
import org.eclipse.ditto.base.model.auth.AuthorizationModelFactory;
import org.eclipse.ditto.base.model.auth.AuthorizationSubject;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.DittoDuration;
import org.eclipse.ditto.base.model.common.ResponseType;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.headers.Header;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.headers.LiveChannelTimeoutStrategy;
import org.eclipse.ditto.base.model.headers.contenttype.ContentType;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTag;
import org.eclipse.ditto.base.model.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.base.model.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@Immutable
public abstract class AbstractDittoHeaders
implements DittoHeaders {
    final Map<String, Header> headers;

    protected AbstractDittoHeaders(Map<String, String> headers) {
        ConditionChecker.checkNotNull(headers, "headers");
        this.headers = headers instanceof AbstractDittoHeaders ? ((AbstractDittoHeaders)headers).headers : AbstractDittoHeaders.indexByLowerCase(headers);
    }

    protected AbstractDittoHeaders(Map<String, Header> headers, boolean flag) {
        ConditionChecker.checkNotNull(headers, "headers");
        this.headers = new LinkedHashMap<String, Header>(headers);
    }

    @Override
    public Map<String, String> asCaseSensitiveMap() {
        LinkedHashMap<String, String> caseSensitiveMap = new LinkedHashMap<String, String>();
        for (Header header : this.headers.values()) {
            caseSensitiveMap.put(header.getKey(), header.getValue());
        }
        return caseSensitiveMap;
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.headers.values().stream().map(Header::getValue).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof CharSequence)) {
            return false;
        }
        String valueString = value.toString();
        return this.headers.values().stream().map(Header::getValue).anyMatch(valueString::equals);
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof CharSequence && this.headers.containsKey(key.toString().toLowerCase());
    }

    @Override
    @Nullable
    public String get(Object key) {
        if (key instanceof String) {
            return Optional.ofNullable(this.headers.get(key.toString().toLowerCase())).map(Header::getValue).orElse(null);
        }
        return null;
    }

    private static JsonObject getAuthorizationContextAsJson(Map<String, ? extends CharSequence> headers) {
        CharSequence jsonObjectString = headers.get(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey());
        JsonObject result = null != jsonObjectString ? JsonObject.of((String)jsonObjectString.toString()) : JsonObject.empty();
        return result;
    }

    @Override
    public Optional<String> getCorrelationId() {
        return this.getStringForDefinition(DittoHeaderDefinition.CORRELATION_ID);
    }

    protected Optional<String> getStringForDefinition(HeaderDefinition definition) {
        return Optional.ofNullable(this.get(definition.getKey()));
    }

    @Override
    public Optional<String> getContentType() {
        return this.getStringForDefinition(DittoHeaderDefinition.CONTENT_TYPE);
    }

    @Override
    public Optional<String> getAccept() {
        return this.getStringForDefinition(DittoHeaderDefinition.ACCEPT);
    }

    @Override
    public Optional<ContentType> getDittoContentType() {
        return this.getContentType().map(ContentType::of);
    }

    @Override
    public Optional<JsonSchemaVersion> getSchemaVersion() {
        return this.getStringForDefinition(DittoHeaderDefinition.SCHEMA_VERSION).map(Integer::valueOf).flatMap(JsonSchemaVersion::forInt);
    }

    @Override
    public AuthorizationContext getAuthorizationContext() {
        return AuthorizationModelFactory.newAuthContext(AbstractDittoHeaders.getAuthorizationContextAsJson(this.headers));
    }

    protected JsonArray getJsonArrayForDefinition(HeaderDefinition definition) {
        Header jsonArrayHeader = this.headers.get(definition.getKey());
        JsonArray result = null != jsonArrayHeader ? JsonArray.of((String)jsonArrayHeader.getValue()) : JsonArray.empty();
        return result;
    }

    @Override
    public Set<AuthorizationSubject> getReadGrantedSubjects() {
        return this.getAuthorizationSubjectSet(DittoHeaderDefinition.READ_SUBJECTS);
    }

    private Set<AuthorizationSubject> getAuthorizationSubjectSet(HeaderDefinition definition) {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(definition);
        return jsonValueArray.stream().map(JsonValue::asString).map(AuthorizationSubject::newInstance).collect(Collectors.toSet());
    }

    @Override
    public Set<AuthorizationSubject> getReadRevokedSubjects() {
        return this.getAuthorizationSubjectSet(DittoHeaderDefinition.READ_REVOKED_SUBJECTS);
    }

    @Override
    public Optional<String> getChannel() {
        return this.getStringForDefinition(DittoHeaderDefinition.CHANNEL);
    }

    @Override
    public boolean isResponseRequired() {
        return !this.isExpectedBoolean(DittoHeaderDefinition.RESPONSE_REQUIRED, Boolean.FALSE);
    }

    protected boolean isExpectedBoolean(HeaderDefinition headerDefinition, Boolean expected) {
        String expectedString = expected.toString();
        return Optional.ofNullable(this.headers.get(headerDefinition.getKey())).map(Header::getValue).filter(expectedString::equalsIgnoreCase).isPresent();
    }

    protected abstract Optional<HeaderDefinition> getSpecificDefinitionByKey(CharSequence var1);

    @Override
    public boolean isDryRun() {
        return this.isExpectedBoolean(DittoHeaderDefinition.DRY_RUN, Boolean.TRUE);
    }

    @Override
    public boolean isSudo() {
        return this.isExpectedBoolean(DittoHeaderDefinition.DITTO_SUDO, Boolean.TRUE);
    }

    @Override
    public boolean shouldRetrieveDeleted() {
        return this.isExpectedBoolean(DittoHeaderDefinition.DITTO_RETRIEVE_DELETED, Boolean.TRUE);
    }

    @Override
    public Optional<String> getCondition() {
        return this.getStringForDefinition(DittoHeaderDefinition.CONDITION);
    }

    @Override
    public Optional<String> getLiveChannelCondition() {
        return this.getStringForDefinition(DittoHeaderDefinition.LIVE_CHANNEL_CONDITION);
    }

    @Override
    public boolean didLiveChannelConditionMatch() {
        return this.isExpectedBoolean(DittoHeaderDefinition.LIVE_CHANNEL_CONDITION_MATCHED, Boolean.TRUE);
    }

    @Override
    public Optional<String> getOrigin() {
        return this.getStringForDefinition(DittoHeaderDefinition.ORIGIN);
    }

    @Override
    public Optional<EntityTag> getETag() {
        return this.getStringForDefinition(DittoHeaderDefinition.ETAG).map(EntityTag::fromString);
    }

    @Override
    public Optional<EntityTagMatchers> getIfMatch() {
        return this.getStringForDefinition(DittoHeaderDefinition.IF_MATCH).map(EntityTagMatchers::fromCommaSeparatedString);
    }

    @Override
    public Optional<EntityTagMatchers> getIfNoneMatch() {
        return this.getStringForDefinition(DittoHeaderDefinition.IF_NONE_MATCH).map(EntityTagMatchers::fromCommaSeparatedString);
    }

    @Override
    public Optional<String> getInboundPayloadMapper() {
        return this.getStringForDefinition(DittoHeaderDefinition.INBOUND_PAYLOAD_MAPPER);
    }

    @Override
    public Optional<Integer> getReplyTarget() {
        return this.getStringForDefinition(DittoHeaderDefinition.REPLY_TARGET).map(Integer::valueOf);
    }

    @Override
    public Collection<ResponseType> getExpectedResponseTypes() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.EXPECTED_RESPONSE_TYPES);
        return jsonValueArray.stream().map(JsonValue::asString).map(ResponseType::fromName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Set<AcknowledgementRequest> getAcknowledgementRequests() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.REQUESTED_ACKS);
        return jsonValueArray.stream().map(JsonValue::asString).map(AcknowledgementRequest::parseAcknowledgementRequest).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Optional<Duration> getTimeout() {
        return this.getStringForDefinition(DittoHeaderDefinition.TIMEOUT).map(DittoDuration::parseDuration).map(DittoDuration::getDuration);
    }

    @Override
    public Optional<LiveChannelTimeoutStrategy> getLiveChannelTimeoutStrategy() {
        return this.getStringForDefinition(DittoHeaderDefinition.LIVE_CHANNEL_TIMEOUT_STRATEGY).flatMap(LiveChannelTimeoutStrategy::forHeaderValue);
    }

    @Override
    public MetadataHeaders getMetadataHeadersToPut() {
        String metadataHeaderValue = this.getOrDefault(DittoHeaderDefinition.PUT_METADATA.getKey(), "");
        return MetadataHeaders.parseMetadataHeaders(metadataHeaderValue);
    }

    @Override
    public Set<JsonPointer> getMetadataFieldsToGet() {
        String metadataFieldSelector = this.getOrDefault(DittoHeaderDefinition.GET_METADATA.getKey(), "");
        return JsonFactory.newFieldSelector((String)metadataFieldSelector, (JsonParseOptions)JsonParseOptions.newBuilder().withoutUrlDecoding().build()).getPointers();
    }

    @Override
    public Set<JsonPointer> getMetadataFieldsToDelete() {
        String metadataFieldSelector = this.getOrDefault(DittoHeaderDefinition.DELETE_METADATA.getKey(), "");
        return JsonFactory.newFieldSelector((String)metadataFieldSelector, (JsonParseOptions)JsonParseOptions.newBuilder().withoutUrlDecoding().build()).getPointers();
    }

    @Override
    public boolean isAllowPolicyLockout() {
        return this.isExpectedBoolean(DittoHeaderDefinition.ALLOW_POLICY_LOCKOUT, Boolean.TRUE);
    }

    @Override
    public Set<String> getJournalTags() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.EVENT_JOURNAL_TAGS);
        return jsonValueArray.stream().map(JsonValue::asString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Optional<String> getTraceParent() {
        return this.getStringForDefinition(DittoHeaderDefinition.W3C_TRACEPARENT);
    }

    @Override
    public Optional<String> getTraceState() {
        return this.getStringForDefinition(DittoHeaderDefinition.W3C_TRACESTATE);
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonObject.newBuilder();
        this.headers.forEach((key, header) -> {
            Class<?> type = this.getSerializationTypeForKey((CharSequence)key);
            JsonValue jsonValue = CharSequence.class.isAssignableFrom(type) ? JsonValue.of((String)header.getValue()) : JsonFactory.readFrom((String)header.getValue());
            jsonObjectBuilder.set((CharSequence)header.getKey(), jsonValue);
        });
        return jsonObjectBuilder.build();
    }

    private Class<?> getSerializationTypeForKey(CharSequence key) {
        return this.getSpecificDefinitionByKey(key).map(HeaderDefinition::getSerializationType).orElseGet(() -> DittoHeaderDefinition.forKey(key).map(HeaderDefinition::getSerializationType).orElse(String.class));
    }

    @Override
    public String put(String key, String value) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    private static UnsupportedOperationException newUnsupportedOperationException() {
        return new UnsupportedOperationException("Ditto Headers are immutable!");
    }

    @Override
    public String remove(Object key) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ? extends String> m) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> entrySet() {
        Set linkedHashSet = this.headers.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), ((Header)entry.getValue()).getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(linkedHashSet);
    }

    @Override
    public boolean isEntriesSizeGreaterThan(long size) {
        ConditionChecker.checkArgument(size, s -> 0L <= size, () -> MessageFormat.format("The size to compare to must not be negative but it was <{0}>!", size));
        long quota = size;
        for (Header header : this.headers.values()) {
            if (0L <= (quota -= (long)AbstractDittoHeaders.getHeaderLength(header))) continue;
            return true;
        }
        return false;
    }

    @Override
    public DittoHeaders truncate(long maxSizeBytes) {
        ConditionChecker.checkArgument(maxSizeBytes, s -> 0L <= maxSizeBytes, () -> MessageFormat.format("The max size bytes must not be negative but it was <{0}>!", maxSizeBytes));
        DittoHeadersBuilder builder = DittoHeaders.newBuilder();
        long quota = maxSizeBytes;
        for (Header entry : this.getSortedHeadersByLength()) {
            if ((quota -= (long)AbstractDittoHeaders.getHeaderLength(entry)) < 0L) break;
            builder.putHeader(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Nonnull
    private List<Header> getSortedHeadersByLength() {
        return this.headers.values().stream().sorted(Comparator.comparingInt(AbstractDittoHeaders::getHeaderLength)).collect(Collectors.toList());
    }

    public String toString() {
        return this.headers.toString();
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractDittoHeaders) {
            AbstractDittoHeaders that = (AbstractDittoHeaders)other;
            return Objects.equals(this.headers, that.headers);
        }
        if (other instanceof Map) {
            return this.headers.equals(other);
        }
        return false;
    }

    private static int getHeaderLength(Header header) {
        return header.getKey().length() + header.getValue().length();
    }

    private static Map<String, Header> indexByLowerCase(Map<String, String> map) {
        LinkedHashMap headers = new LinkedHashMap();
        map.forEach((key, value) -> headers.put(key.toLowerCase(), Header.of(key, value)));
        return Collections.unmodifiableMap(headers);
    }
}

