/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@JsonParsableException(errorCode="entity.notcreatable")
@Immutable
public final class EntityNotCreatableException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "entity.notcreatable";
    static final String MESSAGE_TEMPLATE = "The Entity with ID ''{0}'' could not be created as the creation was configured not to be allowed.";
    static final String DEFAULT_DESCRIPTION = "The creation was configured not to be allowed for the authenticated subject. Check with your administrator if that was unexpected.";
    private static final long serialVersionUID = 8372510019176456321L;
    private final String entityId;

    private EntityNotCreatableException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href, @Nullable CharSequence entityId) {
        super(ERROR_CODE, HttpStatus.FORBIDDEN, dittoHeaders, message, description, cause, href);
        this.entityId = null != entityId ? entityId.toString() : null;
    }

    public static Builder newBuilder(@Nullable CharSequence entityId) {
        return new Builder(entityId);
    }

    public static EntityNotCreatableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder(EntityNotCreatableException.readEntityId(jsonObject).orElse(null)));
    }

    private static Optional<String> readEntityId(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "JSON object");
        return jsonObject.getValue(JsonFields.ENTITY_ID);
    }

    @Override
    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JsonFields.ENTITY_ID, (Object)this.entityId, predicate);
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder(null).message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityNotCreatableException that = (EntityNotCreatableException)o;
        return Objects.equals(this.entityId, that.entityId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityId);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<EntityNotCreatableException> {
        @Nullable
        private final CharSequence entityId;

        private Builder(@Nullable CharSequence entityId) {
            this.entityId = entityId;
            this.message(MessageFormat.format(EntityNotCreatableException.MESSAGE_TEMPLATE, entityId));
            this.description(EntityNotCreatableException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected EntityNotCreatableException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new EntityNotCreatableException(dittoHeaders, message, description, cause, href, this.entityId);
        }
    }

    @Immutable
    public static final class JsonFields {
        static final JsonFieldDefinition<String> ENTITY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"entityId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.HIDDEN, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

