/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.atteo.classindex.IndexSubclasses;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersSettable;
import org.eclipse.ditto.base.model.headers.WithManifest;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@IndexSubclasses
public abstract class DittoRuntimeException
extends RuntimeException
implements Jsonifiable.WithPredicate<JsonObject, JsonField>,
DittoHeadersSettable<DittoRuntimeException>,
WithManifest {
    private final String errorCode;
    private final HttpStatus httpStatus;
    private final String description;
    private final URI href;
    private final transient DittoHeaders dittoHeaders;

    protected DittoRuntimeException(String errorCode, HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(message, cause);
        this.errorCode = ConditionChecker.checkNotNull(errorCode, "error code");
        this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "Ditto headers");
        this.description = description;
        this.href = href;
    }

    public static DittoRuntimeException asDittoRuntimeException(Throwable throwable, Function<Throwable, DittoRuntimeException> alternativeExceptionBuilder) {
        Throwable cause = DittoRuntimeException.getRootCause(throwable);
        if (cause instanceof DittoRuntimeException) {
            return (DittoRuntimeException)cause;
        }
        return alternativeExceptionBuilder.apply(cause);
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if ((throwable instanceof CompletionException || throwable instanceof ExecutionException) && null != (cause = throwable.getCause())) {
            return DittoRuntimeException.getRootCause(cause);
        }
        return throwable;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.dittoHeaders.getSchemaVersion().orElse(this.getLatestSchemaVersion());
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<URI> getHref() {
        return Optional.ofNullable(this.href);
    }

    @Override
    public String getManifest() {
        return this.getErrorCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DittoRuntimeException that = (DittoRuntimeException)o;
        return Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.httpStatus, that.httpStatus) && Objects.equals(this.description, that.description) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.href, that.href);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.httpStatus, this.description, this.getMessage(), this.href);
    }

    @Override
    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        Predicate<JsonField> nonNullAndCustomDefined = predicate.and(JsonField.isValueNonNull());
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(JsonFields.STATUS, (Object)this.httpStatus.getCode(), nonNullAndCustomDefined).set(JsonFields.ERROR_CODE, (Object)this.errorCode, nonNullAndCustomDefined).set(JsonFields.MESSAGE, (Object)this.getMessage(), nonNullAndCustomDefined).set(JsonFields.DESCRIPTION, (Object)this.description, nonNullAndCustomDefined).set(JsonFields.HREF, (Object)(this.href != null ? this.href.toString() : null), nonNullAndCustomDefined);
        this.appendToJson(jsonObjectBuilder, nonNullAndCustomDefined);
        return jsonObjectBuilder.build();
    }

    public static <T extends DittoRuntimeException> T fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders, DittoRuntimeExceptionBuilder<T> builder) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        ConditionChecker.checkNotNull(builder, "builder");
        jsonObject.getValue(JsonFields.DESCRIPTION).ifPresent(builder::description);
        jsonObject.getValue(JsonFields.HREF).map(URI::create).ifPresent(builder::href);
        return builder.dittoHeaders(dittoHeaders).message((String)jsonObject.getValueOrThrow(JsonFields.MESSAGE)).build();
    }

    public static <T extends DittoRuntimeException> T fromMessage(@Nullable String message, DittoHeaders dittoHeaders, DittoRuntimeExceptionBuilder<T> builder) {
        ConditionChecker.checkNotNull(builder, "builder");
        return builder.dittoHeaders(dittoHeaders).message(message).build();
    }

    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
    }

    protected <T extends DittoRuntimeException> DittoRuntimeExceptionBuilder<T> toBuilder(DittoRuntimeExceptionBuilder<T> builder) {
        builder.message(this.getMessage());
        builder.dittoHeaders(this.getDittoHeaders());
        builder.cause(this.getCause());
        this.getHref().ifPresent(builder::href);
        this.getDescription().ifPresent(builder::description);
        return builder;
    }

    protected static Optional<HttpStatus> getHttpStatus(JsonObject jsonObject) {
        return jsonObject.getValue(JsonFields.STATUS).flatMap(HttpStatus::tryGetInstance);
    }

    protected static Optional<URI> getHref(JsonObject jsonObject) {
        Function<String, URI> uriForStringOrNull = uriString -> {
            try {
                return new URI((String)uriString);
            }
            catch (URISyntaxException e) {
                return null;
            }
        };
        return jsonObject.getValue(JsonFields.HREF).map(uriForStringOrNull);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [message='" + this.getMessage() + '\'' + ", errorCode=" + this.errorCode + ", httpStatus=" + this.httpStatus + ", description='" + this.description + '\'' + ", href=" + this.href + ", dittoHeaders=" + this.dittoHeaders + ']';
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> STATUS = JsonFactory.newIntFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ERROR_CODE = JsonFactory.newStringFieldDefinition((CharSequence)"error", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> MESSAGE = JsonFactory.newStringFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> DESCRIPTION = JsonFactory.newStringFieldDefinition((CharSequence)"description", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> HREF = JsonFactory.newStringFieldDefinition((CharSequence)"href", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

