/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@JsonParsableException(errorCode="header.notsupported")
@Immutable
public final class DittoHeaderNotSupportedException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "header.notsupported";
    private static final String DEFAULT_MESSAGE = "The header is not supported.";
    private static final String MESSAGE_TEMPLATE = "The value ''{0}'' of the header ''{1}'' is not supported on this resource level.";
    private static final String DEFAULT_DESCRIPTION = "Verify that the header has the correct syntax and is used on the correct resource level.";
    private static final long serialVersionUID = -6073509778207603606L;
    static final JsonFieldDefinition<String> JSON_FIELD_NOT_SUPPORTED_HEADER_KEY = JsonFieldDefinition.ofString((CharSequence)"notSupportedHeaderKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    @Nullable
    private final String notSupportedHeaderKey;

    private DittoHeaderNotSupportedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href, @Nullable String notSupportedHeaderKey) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
        this.notSupportedHeaderKey = notSupportedHeaderKey;
    }

    public static Builder newInvalidTypeBuilder(String headerName, @Nullable CharSequence headerValue) {
        return new Builder(headerName, headerValue);
    }

    public static Builder newInvalidTypeBuilder(HeaderDefinition headerDefinition, @Nullable CharSequence headerValue) {
        return new Builder(headerDefinition.getKey(), headerValue);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DittoHeaderNotSupportedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        Builder builder = new Builder();
        builder.withNotSupportedHeaderKey(jsonObject.getValue(JSON_FIELD_NOT_SUPPORTED_HEADER_KEY).orElse(null));
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, builder);
    }

    public Optional<String> getNotSupportedHeaderKey() {
        return Optional.ofNullable(this.notSupportedHeaderKey);
    }

    @Override
    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
        if (null != this.notSupportedHeaderKey) {
            jsonObjectBuilder.set(JSON_FIELD_NOT_SUPPORTED_HEADER_KEY, (Object)this.notSupportedHeaderKey, predicate);
        }
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DittoHeaderNotSupportedException that = (DittoHeaderNotSupportedException)o;
        return Objects.equals(this.notSupportedHeaderKey, that.notSupportedHeaderKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.notSupportedHeaderKey);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoHeaderNotSupportedException> {
        @Nullable
        private String notSupportedHeaderKey;

        private Builder() {
            this.notSupportedHeaderKey = null;
            this.message(DittoHeaderNotSupportedException.DEFAULT_MESSAGE);
            this.description(DittoHeaderNotSupportedException.DEFAULT_DESCRIPTION);
        }

        private Builder(String headerName, @Nullable CharSequence headerValue) {
            this.notSupportedHeaderKey = headerName;
            this.message(MessageFormat.format(DittoHeaderNotSupportedException.MESSAGE_TEMPLATE, String.valueOf(headerValue), Objects.requireNonNull(headerName)));
            this.description(DittoHeaderNotSupportedException.DEFAULT_DESCRIPTION);
        }

        public Builder withNotSupportedHeaderKey(@Nullable CharSequence notSupportedHeaderKey) {
            this.notSupportedHeaderKey = null != notSupportedHeaderKey ? notSupportedHeaderKey.toString() : null;
            return this;
        }

        @Override
        protected DittoHeaderNotSupportedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoHeaderNotSupportedException(dittoHeaders, message, description, cause, href, this.notSupportedHeaderKey);
        }
    }
}

