/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.HeaderDefinition;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@JsonParsableException(errorCode="header.invalid")
@Immutable
public final class DittoHeaderInvalidException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "header.invalid";
    private static final String DEFAULT_MESSAGE = "The value of a header is invalid.";
    private static final String MESSAGE_TEMPLATE = "The value ''{0}'' of the header ''{1}'' is not a valid {2}.";
    private static final String DEFAULT_DESCRIPTION = "Verify that the header has the correct syntax and try again.";
    private static final String DESCRIPTION_TEMPLATE = "Verify that the value of the header ''{0}'' is a valid ''{1}'' and try again.";
    private static final long serialVersionUID = -2338222496153977081L;
    static final JsonFieldDefinition<String> JSON_FIELD_INVALID_HEADER_KEY = JsonFieldDefinition.ofString((CharSequence)"invalidHeaderKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    @Nullable
    private final String invalidHeaderKey;

    private DittoHeaderInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href, @Nullable String invalidHeaderKey) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
        this.invalidHeaderKey = invalidHeaderKey;
    }

    public static Builder newInvalidTypeBuilder(String headerName, @Nullable CharSequence headerValue, String headerType) {
        return new Builder(headerName, headerValue, headerType);
    }

    public static Builder newInvalidTypeBuilder(HeaderDefinition headerDefinition, @Nullable CharSequence headerValue, String headerType) {
        return new Builder(headerDefinition.getKey(), headerValue, headerType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DittoHeaderInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        Builder builder = new Builder();
        builder.withInvalidHeaderKey(jsonObject.getValue(JSON_FIELD_INVALID_HEADER_KEY).orElse(null));
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, builder);
    }

    public Optional<String> getInvalidHeaderKey() {
        return Optional.ofNullable(this.invalidHeaderKey);
    }

    @Override
    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
        if (null != this.invalidHeaderKey) {
            jsonObjectBuilder.set(JSON_FIELD_INVALID_HEADER_KEY, (Object)this.invalidHeaderKey, predicate);
        }
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DittoHeaderInvalidException that = (DittoHeaderInvalidException)o;
        return Objects.equals(this.invalidHeaderKey, that.invalidHeaderKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.invalidHeaderKey);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoHeaderInvalidException> {
        @Nullable
        private String invalidHeaderKey;

        private Builder() {
            this.invalidHeaderKey = null;
            this.message(DittoHeaderInvalidException.DEFAULT_MESSAGE);
            this.description(DittoHeaderInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String headerName, @Nullable CharSequence headerValue, String headerType) {
            this.invalidHeaderKey = headerName;
            this.message(MessageFormat.format(DittoHeaderInvalidException.MESSAGE_TEMPLATE, String.valueOf(headerValue), Objects.requireNonNull(headerName), Objects.requireNonNull(headerType)));
            this.description(MessageFormat.format(DittoHeaderInvalidException.DESCRIPTION_TEMPLATE, headerName, headerType));
        }

        private Builder(String customMessage) {
            this();
            this.message(customMessage);
        }

        public Builder withInvalidHeaderKey(@Nullable CharSequence invalidHeaderKey) {
            this.invalidHeaderKey = null != invalidHeaderKey ? invalidHeaderKey.toString() : null;
            return this;
        }

        @Override
        protected DittoHeaderInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoHeaderInvalidException(dittoHeaders, message, description, cause, href, this.invalidHeaderKey);
        }
    }
}

