/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="cloudevent.payload.missing")
@Immutable
public final class CloudEventMissingPayloadException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "cloudevent.payload.missing";
    private static final String DEFAULT_MESSAGE = "The Cloud Event's payload is missing.";
    private static final String DEFAULT_DESCRIPTION = "Ensure to provide payload in the Cloud Event.";
    private static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;

    private CloudEventMissingPayloadException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HTTP_STATUS, dittoHeaders, message, description, cause, href);
    }

    public static DittoRuntimeExceptionBuilder<CloudEventMissingPayloadException> withDetailedInformationBuilder() {
        return new Builder().message(DEFAULT_MESSAGE).description(DEFAULT_DESCRIPTION);
    }

    public static CloudEventMissingPayloadException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CloudEventMissingPayloadException> {
        private Builder() {
            this.message(CloudEventMissingPayloadException.DEFAULT_MESSAGE);
        }

        @Override
        protected CloudEventMissingPayloadException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CloudEventMissingPayloadException(dittoHeaders, message, description, cause, href);
        }
    }
}

