/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.exceptions;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="ask.error")
@Immutable
public final class AskException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "ask.error";
    private static final String DEFAULT_MESSAGE = "There was an internal timeout.";
    private static final String DEFAULT_DESCRIPTION = "Please retry the performed action in order to improve resiliency.";
    private static final long serialVersionUID = 2957834627823947143L;

    private AskException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.SERVICE_UNAVAILABLE, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AskException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static AskException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AskException> {
        private Builder() {
            this.message(AskException.DEFAULT_MESSAGE);
            this.description(AskException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AskException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AskException(dittoHeaders, message, description, cause, href);
        }
    }
}

