/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.validation;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.Validator;

@Immutable
public abstract class AbstractPatternValidator
implements Validator {
    private static final int MAX_LENGTH = 256;
    private final CharSequence id;
    private final Pattern pattern;
    private final String patternErrorMessage;
    @Nullable
    private String reason = null;

    protected AbstractPatternValidator(CharSequence id, Pattern pattern, String patternErrorMessage) {
        this.id = id;
        this.pattern = Objects.requireNonNull(pattern, "The pattern to be validated against must not be null!");
        this.patternErrorMessage = Objects.requireNonNull(patternErrorMessage, "The message describing a mismatch must not be null!");
    }

    @Override
    public boolean isValid() {
        if (this.id.length() > 256) {
            this.reason = String.format("Not allowed to exceed length of %d.", 256);
            return false;
        }
        if (!this.pattern.matcher(this.id).matches()) {
            this.reason = this.patternErrorMessage;
            return false;
        }
        return true;
    }

    @Override
    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }
}

