/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.type;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

@Immutable
public final class EntityTypeJsonDeserializer {
    private EntityTypeJsonDeserializer() {
        throw new AssertionError();
    }

    public static EntityType deserializeEntityType(JsonObject jsonObject, JsonFieldDefinition<String> fieldDefinition) {
        try {
            return EntityType.of((CharSequence)jsonObject.getValueOrThrow(fieldDefinition));
        }
        catch (IllegalArgumentException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize value of key <{0}> as {1}: {2}", fieldDefinition.getPointer(), EntityType.class.getName(), e.getMessage())).cause((Throwable)e).build();
        }
    }
}

