/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityIdInvalidException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@JsonParsableException(errorCode="namespacedentity.id.invalid")
@Immutable
public final class NamespacedEntityIdInvalidException
extends EntityIdInvalidException {
    public static final String ERROR_CODE = "namespacedentity.id.invalid";
    private static final String MESSAGE_TEMPLATE = "Namespaced entity ID ''{0}'' is not valid!";
    private static final String NAMESPACED_ENTITY_ID_DESCRIPTION = "It must conform to the namespaced entity ID notation (see Ditto documentation) with a maximum name length of 256 characters.";
    private static final URI DEFAULT_HREF = URI.create("https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id");
    private static final long serialVersionUID = -8903476318490123234L;
    private final transient CharSequence entityId;

    private NamespacedEntityIdInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href, @Nullable CharSequence entityId) {
        super(ERROR_CODE, dittoHeaders, message, description, cause, href);
        this.entityId = entityId;
    }

    public static Builder newBuilder(@Nullable CharSequence entityId) {
        return new Builder(entityId, NAMESPACED_ENTITY_ID_DESCRIPTION);
    }

    public static NamespacedEntityIdInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder((CharSequence)NamespacedEntityIdInvalidException.readEntityId(jsonObject).orElse(null)));
    }

    private static Optional<String> readEntityId(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "JSON object");
        return jsonObject.getValue(JsonFields.ENTITY_ID);
    }

    @Override
    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JsonFields.ENTITY_ID, (Object)this.entityId.toString(), predicate);
    }

    public Optional<CharSequence> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder(null).message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedEntityIdInvalidException that = (NamespacedEntityIdInvalidException)o;
        return Objects.equals(this.entityId, that.entityId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityId);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<NamespacedEntityIdInvalidException> {
        private final CharSequence entityId;

        private Builder(@Nullable CharSequence entityId) {
            this.entityId = entityId;
            this.message(MessageFormat.format(NamespacedEntityIdInvalidException.MESSAGE_TEMPLATE, entityId));
            this.href(DEFAULT_HREF);
        }

        private Builder(@Nullable CharSequence entityId, String description) {
            this(entityId);
            this.description(description);
        }

        @Override
        protected NamespacedEntityIdInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new NamespacedEntityIdInvalidException(dittoHeaders, message, description, cause, href, this.entityId);
        }
    }

    @Immutable
    public static final class JsonFields {
        static final JsonFieldDefinition<String> ENTITY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"entityId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.HIDDEN, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

