/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.BaseEntityIdFactory;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.EntityIdFactory;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityId;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityIdFactory;
import org.eclipse.ditto.base.model.entity.type.EntityType;

final class EntityIds {
    @Nullable
    private static EntityIds instance = null;
    private final BaseEntityIdFactory<EntityId> entityIdFactory;
    private final BaseEntityIdFactory<NamespacedEntityId> namespacedEntityIdFactory;

    private EntityIds(BaseEntityIdFactory<EntityId> entityIdFactory, BaseEntityIdFactory<NamespacedEntityId> namespacedEntityIdFactory) {
        this.entityIdFactory = entityIdFactory;
        this.namespacedEntityIdFactory = namespacedEntityIdFactory;
    }

    static EntityIds getInstance() {
        EntityIds result = instance;
        if (null == result) {
            instance = result = EntityIds.newInstance(EntityIdFactory.newInstance(), NamespacedEntityIdFactory.newInstance());
        }
        return result;
    }

    static EntityIds newInstance(BaseEntityIdFactory<EntityId> entityIdFactory, BaseEntityIdFactory<NamespacedEntityId> namespacedEntityIdFactory) {
        return new EntityIds(ConditionChecker.checkNotNull(entityIdFactory, "entityIdFactory"), ConditionChecker.checkNotNull(namespacedEntityIdFactory, "namespacedEntityIdFactory"));
    }

    public NamespacedEntityId getNamespacedEntityId(EntityType entityType, CharSequence entityIdValue) {
        return this.namespacedEntityIdFactory.getEntityId(entityType, entityIdValue);
    }

    public EntityId getEntityId(EntityType entityType, CharSequence entityIdValue) {
        return this.entityIdFactory.getEntityId(entityType, entityIdValue);
    }
}

