/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;

@Immutable
final class EntityIdStaticFactoryMethodResolver {
    private EntityIdStaticFactoryMethodResolver() {
        throw new AssertionError();
    }

    public static Optional<Method> getStaticFactoryMethod(Class<? extends EntityId> entityIdClass) {
        return EntityIdStaticFactoryMethodResolver.declaredMethods(ConditionChecker.checkNotNull(entityIdClass, "entityIdClass")).filter(EntityIdStaticFactoryMethodResolver.isStatic()).filter(EntityIdStaticFactoryMethodResolver.isPublic()).filter(EntityIdStaticFactoryMethodResolver.returnsTypeAssignableFromDeclaringClass()).filter(EntityIdStaticFactoryMethodResolver.hasExactlyOneCharSequenceParameter()).min(EntityIdStaticFactoryMethodResolver.preferredMethodNamesFirst());
    }

    private static Stream<Method> declaredMethods(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredMethods());
    }

    private static Predicate<Method> isStatic() {
        return method -> Modifier.isStatic(method.getModifiers());
    }

    private static Predicate<Method> isPublic() {
        return method -> Modifier.isPublic(method.getModifiers());
    }

    private static Predicate<Method> returnsTypeAssignableFromDeclaringClass() {
        return method -> {
            Class<?> returnType = method.getReturnType();
            return returnType.isAssignableFrom(method.getDeclaringClass());
        };
    }

    private static Predicate<Method> hasExactlyOneCharSequenceParameter() {
        return method -> {
            boolean result;
            if (1 == method.getParameterCount()) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Class<CharSequence> parameterType = parameterTypes[0];
                result = parameterType.isAssignableFrom(CharSequence.class);
            } else {
                result = false;
            }
            return result;
        };
    }

    private static Comparator<Method> preferredMethodNamesFirst() {
        StaticFactoryMethodNameComparator staticFactoryMethodNameComparator = new StaticFactoryMethodNameComparator();
        return (o1, o2) -> staticFactoryMethodNameComparator.compare(o1.getName(), o2.getName());
    }

    static final class StaticFactoryMethodNameComparator
    implements Comparator<String> {
        static final List<String> PREFERRED_METHOD_NAMES_ASCENDING = Collections.unmodifiableList(Arrays.asList("of", "getInstance", "newInstance"));

        StaticFactoryMethodNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            for (String preferredMethodName : PREFERRED_METHOD_NAMES_ASCENDING) {
                if (preferredMethodName.equals(o1)) {
                    return -1;
                }
                if (!preferredMethodName.equals(o2)) continue;
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

