/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.EntityIdInvalidException;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

@Immutable
public final class EntityIdJsonDeserializer {
    private EntityIdJsonDeserializer() {
        throw new AssertionError();
    }

    public static EntityId deserializeEntityId(JsonObject jsonObject, JsonFieldDefinition<String> fieldDefinition, EntityType entityType) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        ConditionChecker.checkNotNull(fieldDefinition, "fieldDefinition");
        ConditionChecker.checkNotNull(entityType, "entityType");
        try {
            return EntityId.of(entityType, (CharSequence)jsonObject.getValueOrThrow(fieldDefinition));
        }
        catch (EntityIdInvalidException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize value of key <{0}> as {1}: {2}", fieldDefinition.getPointer(), EntityId.class.getName(), e.getMessage())).cause((Throwable)e).build();
        }
    }
}

