/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.atteo.classindex.ClassIndex;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.EntityIdInvalidException;
import org.eclipse.ditto.base.model.entity.id.EntityIdStaticFactoryMethodResolver;
import org.eclipse.ditto.base.model.entity.id.TypedEntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;

abstract class BaseEntityIdFactory<T extends EntityId> {
    private final Class<T> entityIdBaseType;
    private final Logger logger;
    private final Map<EntityType, Method> staticFactoryMethods;

    protected BaseEntityIdFactory(Class<T> entityIdBaseType) {
        this.entityIdBaseType = ConditionChecker.checkNotNull(entityIdBaseType, "entityIdBaseType");
        this.logger = Logger.getLogger(this.getClass().getName());
        this.staticFactoryMethods = Collections.unmodifiableMap(this.getStaticFactoryMethodsForEntityIdBaseType());
    }

    private Map<EntityType, Method> getStaticFactoryMethodsForEntityIdBaseType() {
        return BaseEntityIdFactory.typedEntityIdAnnotatedClasses().filter(this.entityIdBaseType::isAssignableFrom).map(aClass -> BaseEntityIdFactory.getStaticFactoryMethodOrThrow(aClass)).collect(Collectors.toMap(BaseEntityIdFactory::resolveEntityType, Function.identity()));
    }

    private static Stream<Class<?>> typedEntityIdAnnotatedClasses() {
        Iterable classIterable = ClassIndex.getAnnotated(TypedEntityId.class);
        return StreamSupport.stream(classIterable.spliterator(), false);
    }

    private static Method getStaticFactoryMethodOrThrow(Class<? extends EntityId> classToInstantiate) {
        return EntityIdStaticFactoryMethodResolver.getStaticFactoryMethod(classToInstantiate).orElseThrow(() -> {
            String pattern = "Could not find required instantiation method named <of> with sole parameter of type <CharSequence> for class <{0}>.";
            return new AssertionError((Object)MessageFormat.format("Could not find required instantiation method named <of> with sole parameter of type <CharSequence> for class <{0}>.", classToInstantiate.getName()));
        });
    }

    private static EntityType resolveEntityType(Method staticFactoryMethod) {
        Class<?> classToInstantiate = staticFactoryMethod.getDeclaringClass();
        TypedEntityId annotation = classToInstantiate.getAnnotation(TypedEntityId.class);
        return EntityType.of(annotation.type());
    }

    T getEntityId(EntityType entityType, CharSequence entityIdValue) {
        T result;
        ConditionChecker.checkNotNull(entityType, "entityType");
        ConditionChecker.checkNotNull(entityIdValue, "entityIdValue");
        Method staticFactoryMethod = this.staticFactoryMethods.get(entityType);
        if (null != staticFactoryMethod) {
            result = this.tryToCallFactoryMethod(staticFactoryMethod, entityType, entityIdValue);
        } else {
            result = this.getFallbackEntityId(entityType, entityIdValue);
            this.logger.log(Level.WARNING, "Could not find implementation for entity ID with type <{0}>. This indicates an architectural flaw, because the ID implementation seems not to be on the classpath. Returning a <{1}> instead.", new Object[]{entityType, result.getClass().getSimpleName()});
        }
        return result;
    }

    private T tryToCallFactoryMethod(Method factoryMethod, EntityType entityType, CharSequence entityIdValue) {
        try {
            return this.callFactoryMethod(factoryMethod, entityType, entityIdValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return this.logExceptionAndGetFallbackEntityId(e, factoryMethod, entityType, entityIdValue);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EntityIdInvalidException) {
                throw (EntityIdInvalidException)cause;
            }
            return this.logExceptionAndGetFallbackEntityId(e, factoryMethod, entityType, entityIdValue);
        }
    }

    private T callFactoryMethod(Method staticFactoryMethod, EntityType entityType, CharSequence entityIdValue) throws InvocationTargetException, IllegalAccessException {
        Object entityIdAsObject = staticFactoryMethod.invoke((Object)entityType, entityIdValue);
        return (T)((EntityId)this.entityIdBaseType.cast(entityIdAsObject));
    }

    private T logExceptionAndGetFallbackEntityId(Throwable exception, Method staticFactoryMethod, EntityType entityType, CharSequence entityIdValue) {
        T fallbackEntityId = this.getFallbackEntityId(entityType, entityIdValue);
        String pattern = "Encountered exception <{0}> while calling <{1}>: {2}. Returning a <{3}> instead.";
        String msg = MessageFormat.format("Encountered exception <{0}> while calling <{1}>: {2}. Returning a <{3}> instead.", exception.getClass().getSimpleName(), staticFactoryMethod, exception.getMessage(), fallbackEntityId.getClass().getSimpleName());
        this.logger.log(Level.WARNING, msg, exception);
        return fallbackEntityId;
    }

    protected abstract T getFallbackEntityId(EntityType var1, CharSequence var2);
}

