/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.entity.id.AbstractEntityId;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityId;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityIdInvalidException;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.entity.validation.EntityIdPatternValidator;

@Immutable
public abstract class AbstractNamespacedEntityId
extends AbstractEntityId
implements NamespacedEntityId {
    private final String namespace;
    private final String name;

    protected AbstractNamespacedEntityId(EntityType entityType, String namespace, String name, boolean shouldValidate) {
        super(entityType, shouldValidate ? AbstractNamespacedEntityId.validate(namespace, name) : namespace + ":" + name);
        this.namespace = namespace;
        this.name = name;
    }

    protected AbstractNamespacedEntityId(EntityType entityType, @Nullable CharSequence entityId) {
        super(entityType, AbstractNamespacedEntityId.getNonEmptyEntityId(entityId));
        EntityIdPatternValidator validator = EntityIdPatternValidator.getInstance(entityId);
        if (!validator.isValid()) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(entityId).build();
        }
        String[] elements = entityId.toString().split(":", 2);
        this.namespace = elements[0];
        this.name = elements[1];
    }

    private static CharSequence getNonEmptyEntityId(@Nullable CharSequence entityId) {
        if (entityId == null || entityId.toString().isEmpty()) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(entityId).build();
        }
        return entityId;
    }

    private static String validate(@Nullable String namespace, @Nullable String name) {
        String sp = namespace + ":" + name;
        if (namespace == null || name == null || !EntityIdPatternValidator.getInstance(sp).isValid()) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(sp).build();
        }
        return sp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

