/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity.id;

import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;

public abstract class AbstractEntityId
implements EntityId {
    private final EntityType entityType;
    private final String id;

    protected AbstractEntityId(EntityType entityType, CharSequence id) {
        this.entityType = ConditionChecker.checkNotNull(entityType, "entityType");
        this.id = ConditionChecker.argumentNotEmpty(id, "entityId").toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEntityId that = (AbstractEntityId)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.entityType, that.entityType);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.id);
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }
}

