/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.entity;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.entity.Revision;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;

@Immutable
public interface Entity<T extends Revision<T>>
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public Optional<? extends EntityId> getEntityId();

    public Optional<T> getRevision();

    public Optional<Instant> getModified();

    public Optional<Instant> getCreated();

    public Optional<Metadata> getMetadata();

    public boolean isDeleted();

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }
}

