/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.common;

import java.util.Arrays;
import java.util.Optional;

public enum ResponseType implements CharSequence
{
    ERROR("error"),
    NACK("nack"),
    RESPONSE("response");

    private final String name;

    private ResponseType(String name) {
        this.name = name;
    }

    public static Optional<ResponseType> fromName(String name) {
        String lowerCaseName = name.toLowerCase();
        return Arrays.stream(ResponseType.values()).filter(responseType -> responseType.name.equals(lowerCaseName)).findAny();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

