/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.common;

import java.util.regex.Pattern;

public final class LikeHelper {
    private static final String LEADING_WILDCARD = "\\Q\\E.*";
    private static final String TRAILING_WILDCARD = ".*\\Q\\E";

    private LikeHelper() {
    }

    public static String convertToRegexSyntax(String expression) {
        if (expression == null) {
            return null;
        }
        String valueString = LikeHelper.replaceRepeatingWildcards(expression);
        if ("*".equals(valueString)) {
            return ".*";
        }
        String escapedString = Pattern.compile(Pattern.quote(valueString)).toString();
        escapedString = escapedString.replaceAll("\\*", "\\\\E.*\\\\Q");
        escapedString = escapedString.replaceAll("\\?", "\\\\E.\\\\Q");
        if (!valueString.startsWith(LEADING_WILDCARD)) {
            escapedString = "^" + escapedString;
        }
        if (!valueString.endsWith(TRAILING_WILDCARD)) {
            escapedString = escapedString + "$";
        }
        return escapedString;
    }

    private static String replaceRepeatingWildcards(String value) {
        return value.replaceAll("\\*{2,}", "*");
    }
}

